//
//     Include file for UNC-CH IBR TIFF format 
//
//     Contains the definition of constants and function prototypes
//
//     Last updated: Jun 24 1997 by Manuel Oliveira
//
//
//     compression mode constants
//
#define NONE        1
#define CCITTRLE    2
#define CCITTFAX3   3
#define CCITTFAX4   4
#define LEMPELZIV   5
#define NeXT        32766
#define MACPACKBITS 32773
//
//     image type constants
//
#define PLANAR      0
#define CYLINDRICAL 1
//
//     constants regarding load/not load the normal vector data
//
#define LOAD_NORMALS      1
#define DONT_LOAD_NORMALS 0


extern int readIBRTIFF(char *FileName, unsigned char **image,
                       float **disparity, float **camera, float **normal,
                       int *width, int *height, char **description,
                       int load_normals, int *image_type);

extern int writeIBRTIFF(char *FileName, unsigned char *image,
                        float *disparity, float *normal, float *camera,
                        int width, int height, int compression,
                        char *description, int image_type);

