/***************************************************/
//  
//   API for reading and writing JPEG files
//   
//   Copyright (c) Manuel M. Oliveira (2001) 
//
//   Function prototypes: ReadJPEG and WriteJPEG
//   
//
//  Examples of how to use these functions 
//  in your program
//
// #include "jpeg_api.h" 
// 
// int
// main(int argc, char *argv[])
//{
//  int w,    // image widht (# of columns) in pixels  
//      h,    // image height (# of rows) in pixels
//      c;    // # of color channels. (e.g., 1 if grayscale image,
//                                           3 if RGB image,
//                                           4 if RGBA image 
//     
//  unsigned char *pixels;   // pointer to a linear array that will 
//                           // contain the pixel information for the
//                           // image. 
//                           // If image RGB -> pixels = RGBRGB...RGB
//                           // If image RGBA-> pixels = RGBARGBA...RGBA
//							 // If image grayscale -> pixels = LL...L (luminance)
//
//   if (!ReadJPEG(argv[1], &pixels, &w, &h, &c)) // argv[1] contains the input file name
//	 {										      // pixels: returns the pixel data
//   ... manipulate the image data                // w, h, c: retun width, height and 
//                                                // # of channels, respectivelly
//    // Now, suppose you would like to write back
//    // the image using a different file name
//    // (say, "output_name.jpg")
//
//        WriteJPEG("output_name.jpg", pixels, w, h, c);
//  
//   }
//   else
//     cerr << "Not a valid JPEG file";
// }
//  
/****************************************************/


extern 
bool ReadJPEG(const char *FName, unsigned char **pixel_data, 
			  int *width, int *height, int *num_channels);

extern
bool WriteJPEG(const char *FName, unsigned char *pixel_data, 
			  int width, int height, int num_channels); 

