#include "jacobi.h"
#include "main.h"

extern /* readonly */ CProxy_Main mainProxy;
extern /* readonly */ int linhas;
extern /* readonly */ int colunas;
extern /* readonly */ int linhasChares;
extern /* readonly */ int colunasChares;

Jacobi::Jacobi() {
  int numElementos = (linhas + 2) * (colunas + 2);
  valores = new double[numElementos];
  memset(valores, 0, sizeof(double) * numElementos);
  temp = new double[numElementos];

  if (thisIndex.x == 0 && thisIndex.y == 0 && valores != NULL) 
    valores[(colunas + 2) + 1] = 1.0;

  alvoChamadas = 1;
  if (thisIndex.x > 0) alvoChamadas++;
  if (thisIndex.x < colunasChares - 1) 
    alvoChamadas++;
  if (thisIndex.y > 0) alvoChamadas++;
  if (thisIndex.y < linhasChares - 1) 
    alvoChamadas++;
  chamadas = 0;  
}
Jacobi::Jacobi(CkMigrateMessage *msg) { }
Jacobi::~Jacobi() {
  if (valores != NULL) delete [] valores;
  if (temp != NULL) delete [] temp;
}

void Jacobi::iniciaEtapa() {
  if (thisIndex.x > 0) {
    for (int i = 0; i < linhas; i++) 
      temp[i] = valores[1 + ((colunas + 2) * (i + 1))];
    thisProxy(thisIndex.x - 1, thisIndex.y).dadosLeste(linhas, temp);
  }
  if (thisIndex.x < colunasChares - 1) {
    for (int i = 0; i < linhas; i++) temp[i] = valores[colunas + ((colunas + 2) * (i + 1))];
    thisProxy(thisIndex.x + 1, thisIndex.y).dadosOeste(linhas, temp);
  }
  if (thisIndex.y > 0) {
    double* bufferPtr = &(valores[(colunas + 2) + 1]);
    thisProxy(thisIndex.x, thisIndex.y - 1).dadosSul(colunas, bufferPtr);
  }
  if (thisIndex.y < linhasChares - 1) {
    double* bufferPtr = &(valores[((colunas + 2) * colunas) + 1]);
    thisProxy(thisIndex.x, thisIndex.y + 1).dadosNorte(colunas, bufferPtr);
  }
  tentaCalcular();
}
void Jacobi::dadosLeste(int tam, double* vals) {
  for (int i = 0; i < linhas; i++) valores[((colunas + 2) * (i + 1)) + colunas + 1] = vals[i];
  tentaCalcular();
}
void Jacobi::dadosOeste(int tam, double* vals) {
  for (int i = 0; i < linhas; i++) valores[((colunas + 2) * (i + 1))] = vals[i];
  tentaCalcular();
}
void Jacobi::dadosNorte(int tam, double* vals) {
  memcpy(&(valores[1]), vals, sizeof(double) * tam);
  tentaCalcular();
}
void Jacobi::dadosSul(int tam, double* vals) {
  memcpy(&(valores[((colunas + 2) * (linhas + 1)) + 1]), vals, sizeof(double) * tam);
  tentaCalcular();
}

void Jacobi::tentaCalcular() {
  chamadas++;
  if (chamadas >= alvoChamadas) {
    chamadas = 0;
    double difMax = calcula();
    mainProxy.recebeDiferenca(difMax);
  }
}
double Jacobi::calcula() {
  memset(temp, 0, sizeof(double) * ((colunas + 2) * (linhas + 2)));
  int inicioX = 1;
  if (thisIndex.x == 0 && thisIndex.y == 0) {
    inicioX = 2;
    temp[(colunas + 2) + 1] = 1.0;
  }

  double difMax = 0.0;
  for (int y = 1; y <= linhas; y++) {
    for (int x = inicioX; x <= colunas; x++) {
      int indice = (y * (colunas + 2)) + x;
      double newVal = valores[indice];
      newVal += valores[indice - 1];
      newVal += valores[indice + 1];
      newVal += valores[indice - (colunas + 2)];
      newVal += valores[indice + (colunas + 2)];
      temp[indice] = newVal / 5.0;
      double diferenca = temp[indice] - valores[indice];
      if (diferenca < 0) diferenca *= -1.0;
      difMax = ((difMax > diferenca) ? (difMax) : (diferenca));
    }
    inicioX = 1;
  }
  double* pontTemp = valores;
  valores = temp;
  temp = pontTemp;
  return difMax;
} 

#include "jacobi.def.h"
