#include "main.h"
#include "jacobi.decl.h"

/* readonly */ CProxy_Main mainProxy;
/* readonly */ int linhas;
/* readonly */ int colunas;
/* readonly */ int linhasChares;
/* readonly */ int colunasChares;

Main::Main(CkMigrateMessage* msg) { }
void Main::iniciaEtapa() {
  difMax = 0.0;
  recebimentos = 0;
  vetorJacobi.iniciaEtapa();
}

void Main::recebeDiferenca(double valorEnviado) {
  difMax = ((valorEnviado > difMax) ? (valorEnviado) : (difMax));
  recebimentos++;
  if (recebimentos >= (linhasChares * colunasChares)) {
    CkPrintf("Main::recebeDiferenca() -> difMax = %lf\n", difMax);
    if (difMax > limiar)
      iniciaEtapa();
    else
      CkExit();
  }
}
Main::Main(CkArgMsg* msg) {
  delete msg;

  linhas = 10;
  colunas = 10;
  linhasChares = 5;
  colunasChares = 5;
  limiar = 0.005;

  CkPrintf("Executando \"Jacobi2D\" em %d PEs com uma matriz de valores de tamanho %dx%d particionada em %dx%d chares e com um limiar de %lf.\n", CkNumPes(), linhas * linhasChares, colunas * colunasChares, linhasChares, colunasChares, limiar);

  mainProxy = thisProxy;
  vetorJacobi = CProxy_Jacobi::ckNew(linhasChares, colunasChares);
  iniciaEtapa(); 
}
#include "main.def.h"
