######################################################################################
# Descrição: 	Extrai todas as amostras de dentro do arquivo TAR e procura, por elas,
# o pacote do bioconductor associado a um arquivo Raw.

######################
# Argumentos iniciais:
# 1) seriesFile
# 2) manufacturer
######################

######################
# Variáveis retornadas:
# 1) annotationPackageName
# 2) samplesArray (Nome de todos os samples inclusos, em vetor)
######################


if(endsWith(seriesFile, ".gz"))
{
  gunzip(seriesFile)
  seriesFile <- substr(seriesFile, 1, nchar(seriesFile) - 3)
}

if(manufacturer == "affymetrix")
{
  library("affy")
  library("affyio")
  untar(seriesFile, exdir = tempdir)
  samplesArray <- list.celfiles(tempdir)
  for(i in 1:length(samplesArray))
  {
    samplesArray[i] <- paste0(tempdir, samplesArray[i])
    gunzip(samplesArray[i])
    samplesArray[i] <- substr(samplesArray[i], 1, nchar(samplesArray[i]) - 3)
  }
  SeriesRawMatrix <- ReadAffy(filenames = samplesArray, widget = FALSE)
  annotationPackageName <- .Call("ReadHeader", samplesArray[1], PACKAGE="affyio")[[1]]
  annotationPackageName <- paste0(tolower(gsub("[[:punct:]]", "", annotationPackageName)), "cdf")
  
} else if(manufacturer == "illumina")
{
  
} else if(manufacturer == "agilent")
{
  
} else {
  IException <- "Fabricante inválido..."
  stop("Fabricante inválido!")
}
































# Carrega os pacotes nos camarotes:
library("affy")
library("GEOquery")
library("RCurl")
library("simpleaffy")
library("gcrma")
library("plier")


# Incluir no treatArgs.cfg: treatMethod (expresso, gcrma ou plier), restoreFile, normalization, bgcorrection, pmcorrection e summarymethod

## TODO: Ver o package -> Processing and Analysis of Affymetrix Oligonucleotide Arrays including Exon Arrays, Whole Genome Arrays and Plate Arrays
# Outro package interessante -> Propagating Uncertainty in Microarray Analysis(including Affymetrix tranditional 3' arrays and exon arrays and Human Transcriptome Array 2.0)

# Lê a tabela de argumentos:
inputParameters<-readParameters(tempdir, inputsfile)

giveSignal(directory = tempdir, percent = 25, message = "Carregando definições...")
IException <- "Erro de carregamento de definições!"

# Restaura sessão anterior da pré-análise, incluindo variáveis como a matriz:
restoreFile<-getParameter(inputParameters,"restoreFile")
load(paste(tempdir, restoreFile, sep = "",collapse = ""))


treatMethod<-getParameter(inputParameters,"treatMethod")






# Realiza o tratamento nos arquivos cel dependendo do tipo escolhido:
do.logFC<-FALSE
normalization<-getParameter(inputParameters,"normalization") # Argumento de normalização



switch(treatMethod,
       expresso = {
         giveSignal(directory = tempdir, percent = 55, message = "Tratando pelo modo Expresso...")
         IException <- "Erro no modo expresso!"
         bgcorrection<-getParameter(inputParameters,"bgcorrection")
         if(bgcorrection != "rma") {do.logFC<<-TRUE}
         pmcorrection<-getParameter(inputParameters,"pmcorrection")
         summarymethod<-getParameter(inputParameters,"summarymethod")
         ArrayGSE <- expresso(ArrayRaw,
                                      bgcorrect.method = bgcorrection,
                                      normalize.method = normalization,
                                      pmcorrect.method = pmcorrection,
                                      summary.method = summarymethod)
         giveSignal(directory = tempdir, percent = 60, message = "Tratado pelo modo Expresso...")
         IException <- "Erro após o modo expresso!"
         
       }, gcrma = {
         bgcorrection<-getParameter(inputParameters,"bgcorrection")
         ArrayGSE <- gcrma(ArrayRaw,
                                   normalize = (if(normalization != "none") TRUE else FALSE),
                                   optical.correct =  (if(bgcorrection != "none") TRUE else FALSE))
       }, plier = {
         pmcorrection<-getParameter(inputParameters,"pmcorrection")
         ArrayGSE <- justPlier(ArrayRaw,
                                       normalize = (if(normalization != "none") TRUE else FALSE),
                                       norm.type = pmcorrection
         )
         do.logFC<<-TRUE } )


giveSignal(directory = tempdir, percent = 55, message = "Definindo matriz...")
IException <- "Erro no processamento da matriz!"

# Define matriz GSE para outros processos:
MatrixArrayGSE<-assayDataElement(ArrayGSE,"exprs")
colnames(MatrixArrayGSE) <- gsub(x = colnames(MatrixArrayGSE),pattern = "[[:punct:]].*", replacement = "", ignore.case = TRUE)


# Salva dados para a próxima sessão:
save.image(file = paste(tempdir, "tempdataset.cfg", sep="", collapse=""))


# END