# TrAnSys
# Elaborado por Itamar José G. Nunes et al.

######################################################################################
# Algoritmo auxiliar derivado do original do oligo, modificado para passar sinais de
# progresso
 
library("oligo")
library("oligoClasses")

read.celfiles.transys <- function(..., filenames, pkgname, phenoData, featureData, experimentData, 
          protocolData, notes, verbose = TRUE, sampleNames, rm.mask = FALSE, 
          rm.outliers = FALSE, rm.extra = FALSE, checkType = TRUE) 
{
  oligoEnv <- environment(read.celfiles)
  filenames <- oligoEnv$getFilenames(filenames = filenames, ...)
  oligoEnv$checkValidFilenames(filenames)
  if (checkType) 
    stopifnot(oligoEnv$checkChipTypes(filenames, verbose, "affymetrix", 
                             TRUE))
  chiptype <- oligoEnv$getCelChipType(filenames[1], TRUE)
  if (missing(pkgname)) 
    pkgname <- cleanPlatformName(chiptype)
  if (requireAnnotation(pkgname, verbose = verbose)) {
    if (verbose) 
      message("Platform design info loaded.")
  }
  else {
    stop("The annotation package, ", pkgname, ", could not be loaded.")
  }
  headdetails <- .Call("ReadHeader", as.character(filenames[1]), 
                       PACKAGE = "affyio")
  if (missing(sampleNames)) 
    sampleNames <- basename(filenames)
  results <- oligoEnv$smartReadCEL(filenames, sampleNames, headdetails = headdetails)
  tmpExprs <- results[["exprMatrix"]]
  intensityFile <- results[["intensityFile"]]
  datetime <- results[["datetime"]]
  rm(results)
  #arrayType <- oligoClasses::kind(get(pkgname))
  #theClass <- switch(arrayType, generic = "GenericFeatureSet", 
  #                   tiling = "TilingFeatureSet", expression = "ExpressionFeatureSet", 
  #                   SNP = "SnpFeatureSet", SNPCNV = "SnpCnvFeatureSet", exon = "ExonFeatureSet", 
  #                   gene = "GeneFeatureSet", hta = "HTAFeatureSet", stop("Unknown array type: ", 
  #                                                                        arrayType))
  theClass <- "AffyBatch"
  out <- new(theClass)
  slot(out, "assayData") <- assayDataNew(exprs = tmpExprs)
  overwrite <- FALSE
  if (missing(phenoData)) {
    phenoData <- oligoEnv$basicPhData1(tmpExprs)
  }
  else {
    overwrite <- TRUE
    sns <- sampleNames(phenoData)
    vmd <- varMetadata(phenoData)
    if (!("channel" %in% colnames(vmd))) {
      warning("'channel' automatically added to varMetadata in phenoData.")
      vmd$channel <- factor(rep("_ALL_", nrow(vmd)), levels = c("exprs", 
                                                                "_ALL_"))
      varMetadata(phenoData) <- vmd
    }
  }
  slot(out, "phenoData") <- phenoData
  if (overwrite) 
    sampleNames(out) <- sns
  rm(phenoData)
  if (missing(featureData)) 
    featureData <- oligoEnv$basicAnnotatedDataFrame(tmpExprs, TRUE)
  slot(out, "featureData") <- featureData
  rm(featureData)
  if (missing(protocolData)) 
    protocolData <- oligoEnv$basicPData(tmpExprs, filenames, datetime)
  if (overwrite) 
    sampleNames(protocolData) <- sns
  slot(out, "protocolData") <- protocolData
  rm(protocolData)
  slot(out, "annotation") <- pkgname
  #slot(out, "manufacturer") <- "Affymetrix"
  #slot(out, "intensityFile") <- intensityFile
  if (validObject(out)) {
    return(out)
  }
  else {
    stop("Resulting object is invalid.")
  }
}