# TrAnSys
# Elaborado por Itamar José G. Nunes et al.

######################################################################################
# Algoritmo de tratar as amostras do tipo Raw

######################
# Argumentos iniciais e sub-argumentos:
# 1) sampleFiles
# 2) treatmentPackage (expresso, gcrma ou plier)
# 2.Expresso)
#   a) bgcorrect (mas, rma ou none)
#   b) normalizeArray (quantiles, loess, qspline ou invariantset)
#   c) pmcorrect (pmonly, subtractmm ou mas)
#   d) summary (avgdiff, liwong ou medianpolish)
# 2.GC-RMA)
#   a) bgcorrect (rma ou none)
#   b) normalizeArray (quantiles ou none)
# 2.Plier)
#   a) normalize (quantiles ou none)
#   b) pmcorrect (together, separate, pmonly ou mmonly)
######################

######################
# Variáveis retornadas:
# 1) doLogFC (booleano, para quando o método for plier ou não envolver RMA)
######################

# %%% Sinal: 1%
giveStatus(percent = 1, message = "Inicializando bibliotecas...")
IException <- "Falha ao abrir uma ou mais bibliotecas."

library("affy")
library("affyio")

source(paste0(functionsDir, "oligoFunctions.R"), encoding="UTF-8-BOM", echo = FALSE, verbose = FALSE)

# %%% Sinal: 10%
giveStatus(percent = 10, message = "Processando amostras tipo RAW...")
IException <- "Falha ao processar as amostras tipo RAW."

altPkg <- cleancdfname(read.celfile.header(sampleFiles[1], "basic")$cdfName)

SeriesRawMatrix <- ReadAffy(filenames = sampleFiles, widget = FALSE, verbose = TRUE)
##SeriesRawMatrix <- read.celfiles.transys(filenames = sampleFiles, pkgname = altPkg)
##slot(SeriesRawMatrix, "cdfName") <- altPkg

# %%% Sinal: 1%
giveStatus(percent = 50, message = paste0("Executando tratamento de amostras com ", toupper(treatmentPackage)))
IException <- paste0("Falha ao processar as amostra com o pacote ", toupper(treatmentPackage))

if(treatmentPackage == "expresso")
{
  IException <- "Erro no modo expresso!"
  library("simpleaffy")
  doBgcorrect <- (bgcorrect != "none")
  SeriesExpressionSet <- expresso(SeriesRawMatrix, bg.correct = doBgcorrect, bgcorrect.method = bgcorrect,
                           normalize.method = normalizeArray, pmcorrect.method = pmcorrect, summary.method = summary)
  
} else if(treatmentPackage == "gcrma")
{
  IException <- "Erro no modo GC-RMA!"
  library("gcrma") # TODO: Este requer o pacote celegansprobe
  SeriesExpressionSet <- gcrma(SeriesRawMatrix,
        normalize = (if(normalizeArray != "none") TRUE else FALSE),
        optical.correct =  (if(bgcorrect != "none") TRUE else FALSE))
  
} else if(treatmentPackage == "plier")
{
  IException <- "Erro no modo Plier!"
  library("plier")
  SeriesExpressionSet <- justPlier(SeriesRawMatrix,
                    normalize = (if(normalizeArray != "none") TRUE else FALSE),
                    norm.type = pmcorrect)
}

# Esse resultado é importante para caso seja necessário fazer logFC durante uma análise de dif. de expressão com o limma
logFormat <- (treatmentPackage != "gcrma" && bgcorrect != "rma")

# Removo do ID as infos desnecessárias
#sampleNames(SeriesExpressionSet@phenoData) <- sub(pattern = "_.*", replacement = "", x = sampleNames(SeriesExpressionSet@phenoData))
#colnames(exprs(SeriesExpressionSet)) <- sub(pattern = "_.*", replacement = "", x = colnames(exprs(SeriesExpressionSet)))

SeriesMatrix<-assayDataElement(SeriesExpressionSet,"exprs")
rawResult <- TRUE


# END