# TrAnSys
# Elaborado por Itamar José G. Nunes et al.

######################################################################################
# Funções para tratar as amostras do tipo Raw da Affymetrix

######################
# Argumentos iniciais e sub-argumentos da função principal (treatAffy):
# 1) sampleFiles
# 2) treatmentPackage (expresso, gcrma ou plier)
# 2.Expresso)
#   a) bgCorrect (mas, rma ou none)
#   b) normMethod (quantiles, loess, qspline ou invariantset)
#   c) pmcorrect (pmonly, subtractmm ou mas)
#   d) summary (avgdiff, liwong ou medianpolish)
# 2.GC-RMA)
#   a) bgCorrect (rma ou none)
#   b) normMethod (quantiles ou none)
# 2.Plier)
#   a) normalize (quantiles ou none)
#   b) pmcorrect (together, separate, pmonly ou mmonly)
# 3) loadedPkg => Ambiente do pacote carregado
######################

######################
# Variáveis retornadas:
# 1) doLogFC (booleano, para quando o método for plier ou não envolver RMA)
######################

library("affy")
library("affyio")

readAffyFiles <- function(sampleFiles) 
{
  affyRaw <- ReadAffy(filenames = sampleFiles, widget = F, verbose = F)
  colnames(exprs(affyRaw)) <- sub(pattern = ".CEL$", replacement = '', x = colnames(exprs(affyRaw)), ignore.case = T)
  rownames(affyRaw@phenoData@data) <- sub(pattern = ".CEL$", replacement = '', x = rownames(affyRaw@phenoData@data), ignore.case = T)
  rownames(affyRaw@protocolData@data) <- sub(pattern = ".CEL$", replacement = '', x = rownames(affyRaw@protocolData@data), ignore.case = T)
  return(affyRaw)
}

treatAffy <- function(affyRaw, treatmentPackage, bgCorrect, normMethod, pmcorrect, summary)
{
  if(treatmentPackage == "expresso")
  {
    library("simpleaffy")
    doBgcorrect <- (bgCorrect != "none")
    eset <- expresso(affyRaw, bg.correct = doBgcorrect, bgcorrect.method = bgCorrect,
                                    normalize.method = normMethod, pmcorrect.method = pmcorrect, summary.method = summary)
    
  } else if(treatmentPackage == "gcrma")
  {
    library("gcrma") # TODO: Este requer o pacote celegansprobe
    eset <- gcrma(affyRaw,
                                 normalize = (if(normMethod != "none") TRUE else FALSE),
                                 optical.correct =  (if(bgCorrect != "none") TRUE else FALSE))
    
  } else if(treatmentPackage == "plier")
  {
    library("plier")
    eset <- justPlier(affyRaw,
                                     normalize = (if(normMethod != "none") TRUE else FALSE),
                                     norm.type = pmcorrect)
  }
  return(eset)
}


affyenv <- environment(expresso)
unlockBinding("updateMe", affyenv)

affyenv$updateMe <- function (object, ...)
{
  .local <- function (object) 
  {
    increment <- get("increment", object@internals)
    i <- get("i", object@internals) + increment
    milestones.i <- get("milestones.i", object@internals)
    milestones <- get("milestones", object@internals)
    touched <- FALSE
    if (i == 1) cat('\n')
    while (milestones.i <= length(milestones) && i >= milestones[milestones.i])
    {
      #cat("#")
      perc <- round(100 * i / tail(milestones, n=1))
      if (exists('giveStatus'))
      {
        giveStatus(percent = perc,
                   message = paste0("Aplicando tratamento estatístico (Método Expresso): ", perc, '%'),
                   engMsg = paste0("Applying statistical treatment (Expresso Method): ", perc, '%'))
      }
      milestones.i <- milestones.i + increment
      touched <- TRUE
    }
    if (touched) {
      assign("milestones.i", milestones.i, envir = object@internals)
      if (.Platform$OS.type == "windows") 
        flush.console()
    }
    assign(x="i",value = i, envir = object@internals)
  }
  .local(object, ...)
}
