# TrAnSys
# Elaborado por Itamar José G. Nunes et al.

######################################################################################
# Algoritmo de tratar as amostras do tipo Raw para arranjos Agilent

######################
# Argumentos iniciais e sub-argumentos:
# 1) sampleFiles
# 2) singleChannel
# 4) manufacturer
######################


# --> Possibilidades iniciais:
# - read.maimages:
# source = "agilent" para median em foreground e agilent.mean para mean em foreground (o MA da agilent consegue detectar fore e background)
# green.only = TRUE para single channel
# manufacturer = "generic", "agilent", "agilent.mean", "genepix", "genepix.custom", "genepix.median"


######################
# Variáveis obtidas:
# 1) SeriesRawMatrix (EListRaw com os dados Raw)
######################


# %%% Sinal: 1%
giveStatus(percent = 1, message = "Inicializando bibliotecas...")
IException <- "Falha ao abrir uma ou mais bibliotecas."
library("limma")

# %%% Carregando algoritmos secundários
giveStatus(percent = 5, message = "Carregando algoritmos secundários...")
IException <- "Falha ao carregar um ou mais algoritmos secundários."

source(paste0(functionsDir, "limmaFunctions.R"), encoding="UTF-8-BOM", echo = FALSE, verbose = FALSE)

# %%% Sinal: 10%
giveStatus(percent = 10, message = "Processando amostras tipo RAW...")
IException <- "Falha ao processar as amostras tipo RAW."

# green.only para single channel
# Nota: Dual-channel tem g e r na linha STATS, enquanto o single-channel só tem o G. Levar isso em conta!
SeriesRawMatrix <- read.maimagesTrAnSys(files = sampleFiles, source = manufacturer, green.only = singleChannel)

colnames(SeriesRawMatrix$E) <- sub(pattern = ".*/", x = colnames(SeriesRawMatrix$E), replacement = "")


remove(list = c("manufacturer", "sampleFiles", "singleChannel"))
