#### Algoritmo de abrir o GSE pela internet e exportá-lo em um arquivo separado

# *************************** Sinal ****************

######################
# Argumentos iniciais:
# 1) seriesFile
# 2) getGPL
# 3) platformFile
######################

######################
# Objetos obtidos:
# 1) SeriesMatrix
# 2) SeriesExpressionSet
# 3) GPL (string, ID da plataforma)
######################


# %%% Sinal: 1%
giveStatus(percent = 1, message = "Inicializando...")
IException <- "Falha ao abrir as bibliotecas."

# Obtém as funções necessárias para carregar os datasets do GEO
source(paste0(functionsDir, "geoQueryFunctions.R"), encoding="UTF-8-BOM", echo = FALSE, verbose = FALSE)


# %%% Sinal: 45%
giveStatus(percent = 45, message = "Carregando o conjunto de dados...")
IException <- "Não foi possível carregar a matriz do arquivo GEO correspondente."

# Abre o GSE e o mantém na memória
#SeriesExpressionSet<-openSeries(fname=seriesFile, getGPL=getGPL)$eset
SeriesExpressionSet<-GEOpreprocess(fname = seriesFile)$eset

# %%% Sinal: 80%
giveStatus(percent = 80, message = "Lendo informações...")
IException <- "Erro ao ler os arquivos phenoData (informações específicas) da matriz do GEO."


#######################
# Obtendo o GPL

GPL<-SeriesExpressionSet$GPL


# %%% Sinal: 90%
giveStatus(percent = 90, message = "Definindo tabela...")
IException <- "Erro ao definir a tabela!"


# Define matriz GSE para outros processos:
SeriesMatrix<-assayDataElement(SeriesExpressionSet,"exprs")


# END