# TrAnSys
# Elaborado por Itamar José G. Nunes et al.

######################################################################################
# Algoritmo de carregar amostras Illumina através do pacote BeadArray

######################
# Argumentos iniciais e sub-argumentos:
# 1) sampleFiles: Nomes dos arquivos das amostras IDAT
# 2) annotFile: Nome do arquivo de anotação BGX
######################


######################
# Variáveis retornadas:
# 1) SeriesRawMatrix (Requer tratamento depois, pelo treatLimma.R)
# 2) PlatformMatrix (Anotação das sondas)
######################

# --> Possibilidades iniciais:
# - readBeadSummaryData:
# skip = número de linhas a serem puladas até chegar a tabela. O mesmo vale pro BGX
# ProbeID = "ID_REF", nome da primeira coluna
# method = "quantile", "qspline", "vsn", "rankInvariant", "median" ou "none"
# transform = "none", "log2", "neqc", "rsn" ou "vst"
# T = vetor de distribuição quando method="rankInvariant". Se nulo, é usada a média



# %%% Sinal: 1%
giveStatus(percent = 1, message = "Inicializando bibliotecas...")
IException <- "Falha ao abrir uma ou mais bibliotecas."
library("limma")

# %%% Carregando algoritmos secundários
giveStatus(percent = 5, message = "Carregando algoritmos secundários...")
IException <- "Falha ao carregar um ou mais algoritmos secundários."

source(paste0(functionsDir, "limmaFunctions.R"), encoding="UTF-8-BOM", echo = FALSE, verbose = FALSE)

IException <- "Falha no carregamento das amostras."

# Para arquivos IDAT, que requerem os arquivos BGX
SeriesRawMatrix <- read.idatTrAnSys(idatfiles = sampleFiles, bgxfile = annotFile)

colnames(SeriesRawMatrix$E) <- sub(pattern = ".*/", x = colnames(SeriesRawMatrix$E), replacement = "")

probeFilter <- which(duplicated(SeriesRawMatrix$genes$Array_Address_Id))

PlatformMatrix <- as.matrix(SeriesRawMatrix$genes[-probeFilter,])
rownames(PlatformMatrix) <- PlatformMatrix[, "ILMN_Gene"]

remove("probeFilter")
