# TrAnSys
# Elaborado por Itamar José G. Nunes et al.

######################################################################################
# Algoritmo de carregar amostras Illumina através do pacote BeadArray

######################
# Argumentos iniciais e sub-argumentos:
# 1) matrixFile: Nome do arquivo de matriz
# 2) annotFile: Nome do arquivo de anotação, ou "?" se não houver arquivo
# 3) skipLines: Número de linhas a serem puladas na matriz principal (geralmente varia entre 0 ou 1)
# 4) idCol: Nome da coluna de ID da sonda, pois pode variar - padrão é "ID_REF"
# 5) normMethod: "quantile", "qspline", "vsn", "rankInvariant", "rsn", "median" ou "none"
# 6) transfMethod: "none", "log2", "neqc" ou "vst"
######################

######################
# Objetos obtidos:
# 1) SeriesMatrix
# 2) SeriesExpressionSet
# 3) PlatformMatrix (Se annotFile != "?")
# 4) PlatformHeader (Se annotFile != "?")
######################

# --> Possibilidades iniciais:
# - readBeadSummaryData:
# skip = número de linhas a serem puladas até chegar a tabela. O mesmo vale pro BGX
# ProbeID = "ID_REF", nome da primeira coluna
# method = "quantile", "qspline", "vsn", "rankInvariant", "rsn", "median" ou "none"
# transform = "none", "log2", "neqc" ou "vst"
# T = vetor de distribuição quando method="rankInvariant". Se nulo, é usada a média
# NOTA: O method = "vsn" já faz log2 dos valores, logo a transform deve ser obrigatoriamente "none"
# NOTA2: A documentação diz transform = "rsn", mas na verdade é method = "rsn"!!
# NOTA3: Quando transform = "neqc", as sondas de controle são removidas
# NOTA4: Mais pra frente, ver como funciona o lance do rankinvariant

# %%% Sinal: 1%
giveStatus(percent = 1, message = "Inicializando bibliotecas...")
IException <- "Falha ao abrir uma ou mais bibliotecas."
library("beadarray")
library("illuminaio")


# %%% Sinal: 5%

giveStatus(percent = 5, message = "Processando matriz...")
IException <- "Erro de leitura da matriz."

# Para matrizes comuns, algumas nas quais começam a partir da segunda linha
SeriesRawMatrix <- readBeadSummaryData(dataFile = matrixFile,
                    skip = skipLines,
                    ProbeID = idCol)


giveStatus(percent = 50, message = "Aplicando tratamento estatístico...")
IException <- "Erro durante tratamento estatístico."

# Abaixo disso, quando tudo for terminado, será deslocado para um R script de tratamento
SeriesExpressionSet <- normaliseIllumina(BSData = SeriesRawMatrix, method = normMethod, transform = transfMethod)

# Define matriz GSE para outros processos:
SeriesMatrix<-assayDataElement(SeriesExpressionSet,"exprs")

if (annotFile != "?"){
  giveStatus(percent = 80, message = "Processando anotação...")
  IException <- "Erro durante a leitura da anotação."
  
  bgx <- readBGX(annotFile)
  PlatformMatrix <- bgx$probes
  rownames(PlatformMatrix) <- PlatformMatrix$Probe_Id
}
