#### Funcões para o ArrayQualityMetrics



# Bibliotecas
library("affy")
library("GEOquery")
library("arrayQualityMetrics")
library("setRNG")
library("genefilter")
library("lattice")
library("SVGAnnotation")
library("Hmisc")
library("vsn")
library("hwriter")
library("gridSVG")
library("Cairo")
library("latticeExtra")
library("grDevices")


####################################################################################################
####################################################################################################
# Redefinindo funções do environment arrayQualityMetrics:

aqmenv <- environment(arrayQualityMetrics)


unlockBinding("reportModule", aqmenv)
unlockBinding("aqm.heatmap", aqmenv)
unlockBinding("arrayQualityMetrics", aqmenv)

aqmenv$arrayQualityMetrics <- function (expressionset, outdir = reporttitle, force = FALSE, 
          do.logtransform = FALSE, intgroup = character(0), 
          spatial = TRUE, reporttitle = paste("arrayQualityMetrics report for", 
                                              deparse(substitute(expressionset))), ...) 
{
  
  for (v in c("outdir", "reporttitle")) if (!(is.character(get(v)) && 
                                              (length(get(v)) == 1))) 
    stop(sprintf("'%s' should be a character of length 1.", 
                 v))
  for (v in c("force", "do.logtransform", "spatial")) if (!(is.logical(get(v)) && 
                                                            (length(get(v)) == 1))) 
    stop(sprintf("'%s' should be a logical of length 1.", 
                 v))
  if (!is.character(intgroup)) 
    stop("'intgroup' should be a character.")
  aqmenv$dircreation(outdir, force)
  m = list()
  old.seed = setRNG(kind = "default", seed = 28051968, normal.kind = "default")
  on.exit(setRNG(old.seed))
  x = prepdata(expressionset, intgroup = intgroup, do.logtransform = do.logtransform)
  pdf(tempfile())
  if (exists('giveStatus')) giveStatus(percent=16, message = "Gerando HeatMaps...", engMsg = "Building HeatMaps...")
  m$heatmap = aqm.heatmap(x, ...)
  if (exists('giveStatus')) giveStatus(percent=32, message = "Gerando PCA...", engMsg = "Building PCA...") else writeLine("hã?")
  m$pca = aqm.pca(x, ...)
  if (exists('giveStatus')) giveStatus(percent=46, message = "Gerando Box Plot...", engMsg = "Building BoxPlot...")
  m$boxplot = aqm.boxplot(x, ...)
  if (exists('giveStatus')) giveStatus(percent=54, message = "Gerando gráfico de estimativas de densidade...", engMsg = "Building density estimates plot...")
  m$density = aqm.density(x, ...)
  if (exists('giveStatus')) giveStatus(percent=68, message = "Gerando gráfico de desvios-padrão de intensidade...", engMsg = "Building intensity standard deviations plot...")
  m$meansd = aqm.meansd(x, ...)
  if (exists('giveStatus')) giveStatus(percent=80, message = "Gerando gráfico de distribuição de intensidades...", engMsg = "Building intensity distributions plot...")
  m$probesmap = aqm.probesmap(x, ...)
  if (is(expressionset, "AffyBatch")) {
    x = prepaffy(expressionset, x)
    m$rle = aqm.rle(x, ...)
    m$nuse = aqm.nuse(x, ...)
    m$rnadeg = aqm.rnadeg(expressionset, x, ...)
    m$pmmm = aqm.pmmm(x, ...)
  }
  if (exists('giveStatus')) giveStatus(percent=90, message = "Gerando gráficos MA...", engMsg = "Building MA plots...")
  m$maplot = aqm.maplot(x, ...)
  if (spatial) 
  {
    if (exists('giveStatus')) giveStatus(percent=96, message = "Gerando gráficos espaciais...", engMsg = "Building spatial plots...")
    m = append(m, aqm.spatial(x, ...))
  }
  if (exists('giveStatus')) giveStatus(percent=100, message = "Finalizando...", engMsg = "Finishing...") 
  res = aqm.writereport(modules = m, arrayTable = x$pData, 
                        reporttitle = reporttitle, outdir = outdir)
  grDevices::dev.off()
  invisible(res)
}


aqmenv$reportModule <- function(p, module, currentIndex, arrayTable, outdir) 
{
  aqmenv = environment(arrayQualityMetrics)
  stopifnot(is(module, "aqmReportModule"))
  validObject(module, test = FALSE)
  svgwarn = FALSE
  stopifnot(!is.na(module@title))
  name = module@id
  stopifnot(!any(is.na(module@size)))
  module@size["h"] <- module@size["h"] * 1.25
  module@size["w"] <- module@size["w"] * 1.25
  h = module@size["h"]
  w = module@size["w"]
  stopifnot(length(currentIndex) == 1, is.numeric(currentIndex), 
            !is.na(currentIndex))
  dpi = environment(arrayQualityMetrics)$arrayQualityMetricsGlobalParameters$dpi
  if (is.na(module@svg@numPlotObjects)) {
    nameimg = paste0(name, ".wmf")
    environment(arrayQualityMetrics)$makePlot(module)
    img = hmakeTag("img", src = nameimg, border = 0, alt = nameimg, 
                   id = paste("Fig", name, sep = "ls:"))
  }
  else if (FALSE) {
    nameimg = paste0(name, ".svg")
    if (is(module@plot, "trellis")) {
      theName = file.path(outdir, nameimg)
      thePrefix = paste("Fig", name, sep = ":")
      eval(substitute(gridsvg(name = theName, width = w, 
                              height = h, res = dpi, prefix = thePrefix, usePaths = "none")))
      environment(arrayQualityMetrics)$makePlot(module)
      annRes = environment(arrayQualityMetrics)$annotateSvgGrid(annotationInfo = module@svg, 
                                                                name = name)
      tryCatch(grDevices::dev.off(), error = function(e) e, finally = writeLines("Usual grDevices bug."))
    }
    else if (FALSE) {
      svgtemp = paste0(tempfile(), ".svg")
      Cairo(file = svgtemp, type = "svg", height = h, width = w, 
            units = "in", dpi = dpi)
      environment(arrayQualityMetrics)$makePlot(module)
      tryCatch(grDevices::dev.off(), error = function(e) e, finally = writeLines("Usual grDevices bug."))
      annRes = environment(arrayQualityMetrics)$annotateSvgPlot(infile = svgtemp, outfile = nameimg, 
                                                                outdir = outdir, annotationInfo = module@svg, 
                                                                name = name)
    }
    if (!annRes$annotateOK & FALSE) 
      svgwarn = paste("Note: the figure is static - enhancement with interactive effects failed.", 
                      "This is either due to a version incompatibility of the 'SVGAnnotation' R package and your", 
                      "version of 'Cairo' or 'libcairo', or due to plot misformating. Please consult the Bioconductor forum, or", 
                      "contact the maintainer of 'arrayQualityMetrics' with a reproducible example to help fix this problem.")
    img = hwrite(c(paste(readLines(file.path(outdir, nameimg), 
                                   warn = FALSE), collapse = "\n"), annotationTable(arrayTable, 
                                                                                    name = name)))
  }
  # PDFs não são exportados mais
  namewmf = paste0(name, ".wmf")
  win.metafile(filename = file.path(outdir, namewmf), height = h * 
                 dpi / 75, width = w * dpi / 75,family = "sans")
  
  environment(arrayQualityMetrics)$makePlot(module)
  tryCatch(grDevices::dev.off(), error = function(e) e, finally = writeLines("Working in plots."))
  if (!identical(NA_character_, module@outliers@description)) {
    currentIndex = currentIndex + 1
    aqmenv$reportModule(p, aqmenv$aqm.outliers(module), currentIndex, arrayTable, 
                  outdir)
  }
  return(currentIndex + 1)
}

aqmenv$aqm.heatmap <- function (x, rgbi = c(1,1,1),rgbf = c(1,0,0)) {
  colorRange = rgb(seq(rgbi[1], rgbf[1], l = 256), seq(rgbi[2], rgbf[2], l = 256), 
                   seq(rgbi[3], rgbf[3], l = 256)) # Aqui que vai as cores!
  aqmenv = environment(arrayQualityMetrics)
  m = dist2(x$M)
  out = outliers(m, method = "sum")
  out@description = c("sum of distances to other arrays <i>S<sub>a</sub></i>", 
                      "data-driven")
  dend = as.dendrogram(hclust(as.dist(m), method = "single"))
  ord = order.dendrogram(dend)
  colnames(m) = rownames(m) = paste0(ifelse(seq_len(x$numArrays) %in% 
                                              out@which, "* ", ""), seq_len(x$numArrays))
  haveDend = (ncol(m) <= (aqmenv$arrayQualityMetricsGlobalParameters)$maxNumberOfArraysForDrawingDendrogram)
  if (haveDend) {
    theLegend = list(right = list(fun = dendrogramGrob, args = list(x = dend, 
                                                                    side = "right")))
    fillOrd = seq_len(x$numArrays)
  }
  else {
    theLegend = NULL
    fillOrd = ord
  }
  maxNrColors = 0
  ng = length(x$intgroup)
  if (ng > 0) {
    palettes = c("Set1", "Set2", "Set3", "Accent", "Dark2", 
                 "Paired", "Pastel1", "Pastel2")
    stopifnot(all(palettes %in% rownames(brewer.pal.info)))
    palettes = rep(palettes, ceiling(ng/length(palettes)))
    key = rects = vector(mode = "list", length = ng)
    names(rects) = rep("rect", ng)
    for (i in seq_len(ng)) {
      colors = brewer.pal(brewer.pal.info[palettes[i], 
                                          "maxcolors"], palettes[i])
      fac = factor(x$pData[[x$intgroup[i]]])
      fac = maximumLevels(fac, n = length(colors))
      colors = colors[seq_len(nlevels(fac))]
      key[[i]] = list(rect = list(col = colors), text = list(levels(fac)))
      rects[[i]] = list(col = "transparent", fill = colors[as.integer(fac)[fillOrd]], 
                        type = "rectangle")
      if (length(colors) > maxNrColors) 
        maxNrColors = length(colors)
    }
    key = unlist(key, recursive = FALSE)
    key$rep = FALSE
    thekey = draw.key(key = key)
    if (haveDend) {
      theLegend$right$args = append(theLegend$right$args, 
                                    list(size.add = 1, add = rects))
    }
    else {
      lay = grid.layout(nrow = 1, ncol = ng, heights = unit(1, 
                                                            "null"), widths = unit(rep(1, length = ng), rep("lines", 
                                                                                                            ng)), respect = FALSE)
      g = frameGrob(layout = lay)
      dy = 1/x$numArrays
      y = seq_len(x$numArrays) * dy
      for (i in seq_len(ng)) {
        g = placeGrob(g, rectGrob(y = y, height = dy, 
                                  vjust = 1, gp = do.call(gpar, rects[[i]])), 
                      row = 1, col = i)
      }
      idem = function(x) x
      theLegend = list(right = list(fun = idem, args = list(x = g)))
    }
  }
  else {
    thekey = NULL
  }
  hfig = levelplot(m[ord, ord], scales = list(x = list(rot = 90)), 
                   legend = theLegend, colorkey = list(space = "left"), 
                   xlab = "", ylab = "", col.regions = colorRange, main = thekey)
  nout = length(out@which)
  legend = paste0("The figure <!-- FIG --> shows a false color heatmap of the distances between arrays. ", 
                  "The color scale is chosen to cover the range of distances encountered in the dataset. ", 
                  "Patterns in this plot can indicate clustering of the arrays either because of intended biological or ", 
                  "unintended experimental factors (batch effects). ", 
                  "The distance <i>d<sub>ab</sub></i> between two arrays <i>a</i> and <i>b</i> is computed as the mean absolute difference ", 
                  "(L<sub>1</sub>-distance) between the data of the arrays (using the data from all probes without filtering). ", 
                  "In formula, <i>d<sub>ab</sub></i> = mean | <i>M<sub>ai</sub> - M<sub>bi</sub></i> |, ", 
                  "where <i>M<sub>ai</sub></i> is the value of the <i>i</i>-th probe on the <i>a</i>-th array. ", 
                  "Outlier detection was performed by looking for arrays for which the sum of the distances to all other arrays, ", 
                  "<i>S<sub>a</sub></i> = &Sigma;<sub><i>b</i></sub> <i>d<sub>ab</sub></i> was exceptionally large. ", 
                  if (nout > 0) 
                    paste(if (nout > 1) 
                      paste(nout, "such arrays were detected, and they are")
                      else "One such array was detected, and it is", "marked by an asterisk, *.")
                  else "No such arrays were detected.")
  new("aqmReportModule", plot = hfig, section = "Between array comparison", 
      title = "Distances between arrays", id = "hm", legend = legend, 
      size = c(w = 5 + x$numArrays * 0.075, h = 3 + x$numArrays * 
                 0.075 + maxNrColors * 0.2), colors = x$arrayColors, 
      outliers = out)
}

