#### Algoritmo de análise de qualidade de um ExpressionSet

# *************************** Sinal ****************

######################
# Argumentos iniciais:
# 1) SeriesMatrix
# 2) incSamples = Array de amostras que serão inclusas (IDs)
# 3) rgbNear = Cor de distância próxima do HeatMap
# 4) rgbFar = Cor de distância longa do HeatMap
# 5) doLogQMetrics = Realizar log2 nos valores?
######################

######################
# Objetos obtidos:
# 1) img11 a img4 = Imagens dos resultados, em wmf
# 2) summaryResults = Array contendo os resultados para cada amostra ('OK' ou testes onde houve outlier)
######################



####################################################################
# TEMPORÁRIO ATÉ FINALIZAR O ALGORITMO

#rgbNear <- c(0, 0, 1)
#rgbFar <- c(1, 0, 0)

#doLogQMetrics <- FALSE

#incSamples <- c("GSM49939", "GSM49940", "GSM49941", "GSM49942", "GSM49943")
  
  
####################################################################




# %%% Sinal: 5%
giveStatus(percent = 5, message = "Carregando bibliotecas...", engMsg = "Loading libraries...")
IException <- "One or more libraries could not be loaded."



# Obtém as funções necessárias para carregar o Array Quality Metrics
source(paste0(functionsDir, "qMetricsFunctions.R"), encoding="UTF-8-BOM", echo = FALSE, verbose = FALSE)




# %%% Sinal: 25%
giveStatus(percent = 25, message = "Carregando parâmetros...", engMsg = "Loading parameters...")
IException <- "Não foi possível ler os parâmetros do arquivo de entrada. \nTambém é possível que não haja os argumentos corretos na entrada."





usedExpressionSet <- asIntegral(SeriesExpressionSet)

# Otimização
if (length(incSamples) < ncol(SeriesMatrix))
{
  # Se quiser fazer um expressionset customizado, essa é a fórmula
  arraytxt <- exprs(usedExpressionSet)[,incSamples]
  datamat<-matrix(data=as.numeric(arraytxt), ncol = ncol(arraytxt), dimnames =  list(rownames(arraytxt), colnames(arraytxt)))
  sampledat<-(usedExpressionSet@phenoData@data)[incSamples,]
  fd = new("AnnotatedDataFrame", data = data.frame(row.names = rownames(datamat)))
  usedExpressionSet <- new("ExpressionSet", phenoData = as(as.data.frame(sampledat), "AnnotatedDataFrame"), 
                           annotation = "GPL", featureData = fd, exprs = as.matrix(datamat))
}





# %%% Sinal: 60%
giveStatus(percent = 60, message = "Fazendo teste de qualidade com Array Quality Metrics...", engMsg = "Testing quality control with Array Quality Metrics...")
IException <- "Ocorreu um erro durante os cálculos da análise de qualidade."



outDir <- toTempDir("qMetrics")

aqmenv <- environment(arrayQualityMetrics)
resultsQMetrics <- aqmenv$arrayQualityMetrics(usedExpressionSet, force=TRUE,
                                              outdir = outDir, rgbi = as.numeric(rgbNear), rgbf = as.numeric(rgbFar), do.logtransform = doLogQMetrics)

tryCatch(expr = { grDevices::dev.off() }, error = function(e) { return(invisible(e)) } )

outFiles <- list.files(path = outDir, pattern = "*.wmf", full.names = TRUE)

img11 <- outFiles[3]
img12 <- outFiles[7]
img13 <- outFiles[9]
img21 <- outFiles[1]
img22 <- outFiles[6]
img23 <- outFiles[2]
img31 <- outFiles[4]
img32 <- outFiles[8]
img4 <- outFiles[5]



# %%% Sinal: 95%
giveStatus(percent = 95, message = "Escrevendo tabelas e finalizando...", engMsg = "Writing tables...")
IException <- "Houve um problema durante a exportação dos dados."



qMetricsSamps<-(resultsQMetrics$arrayTable)$sampleNames

qMetricsOuts1<-(resultsQMetrics$arrayTable)$"<a href=\"#hm\">*1</a>"
qMetricsOuts2<-(resultsQMetrics$arrayTable)$"<a href=\"#box\">*2</a>"
qMetricsOuts3<-(resultsQMetrics$arrayTable)$"<a href=\"#ma\">*3</a>"

summaryResults <- rep(NA, length(incSamples))

for(i in 1:length(incSamples))
{
  currRes <- trimws(paste0(sub("x", " 1", qMetricsOuts1[i]), sub("x", " 2", qMetricsOuts2[i]), sub("x", " 3", qMetricsOuts3[i])))
  if (nchar(currRes) == 0)
    currRes <- "OK"
  summaryResults[i] <- currRes
}








# Para ver as cores disponíveis, dá uma olhada nesse gráfico:
# filled.contour(volcano, color = colorRampPalette(rgb(seq(0, 0, l = 256), seq(0, 0, l = 256), seq(0, 1, l = 256))), asp = 1)


