# TrAnSys
# Elaborado por Itamar José G. Nunes et al.

######################################################################################
# Algoritmo de abrir arquivos SOFT

######################
# Argumentos iniciais e sub-argumentos:
# 1) fileNames : String (Nome dos arquivos SOFT)
# 2) series : Booleano (Série ou amostras?)
# 3) platformFile : String (Caminho do GPL, também SOFT; Se for nulo, não carrega plataforma)
######################

######################
# Objetos obtidos:
# 1) SeriesMatrix
# 2) GPL (string, ID da plataforma)
######################

# Temporário!
#fileNames <- "C:/Users/Tojara/Desktop/lol/GSE2600_series_matrix.txt"
#series <- TRUE
#platformFile <- "C:/Users/Tojara/Desktop/lol/GPL200.txt"
#####

# Obtém as funções necessárias para carregar os datasets do GEO
source(paste0(functionsDir, "geoQueryFunctions.R"), encoding="UTF-8-BOM", echo = FALSE, verbose = FALSE)

if (series){
  seriesData <- GEOpreprocess(fname = fileNames)
  SeriesMatrix <- seriesData$eset
  GPL <- seriesData$GPL
  remove(seriesData)
} else {
  SeriesMatrix <- GEOpreprocessGSM(fileNames)
  GPL <- annotation(SeriesMatrix)
}

if (!is.null(platformFile) && platformFile != ""){
  PlatformMatrix <- readGPL(platformFile)
  #fData(SeriesMatrix) <- PlatformMatrix
  #sampleNames(SeriesMatrix@featureData) <- PlatformMatrix[, 1]
  #remove(PlatformMatrix)
}

