/************************************************************************\

  Copyright 1997 The University of North Carolina at Chapel Hill.
  All Rights Reserved.

  Permission to use, copy, modify and distribute this software
  and its documentation for educational, research and non-profit
  purposes, without fee, and without a written agreement is
  hereby granted, provided that the above copyright notice and
  the following three paragraphs appear in all copies.

  IN NO EVENT SHALL THE UNIVERSITY OF NORTH CAROLINA AT CHAPEL
  HILL BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL,
  INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
  ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
  EVEN IF THE UNIVERSITY OF NORTH CAROLINA HAVE BEEN ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGES.


  Permission to use, copy, modify and distribute this software
  and its documentation for educational, research and non-profit
  purposes, without fee, and without a written agreement is
  hereby granted, provided that the above copyright notice and
  the following three paragraphs appear in all copies.

  THE UNIVERSITY OF NORTH CAROLINA SPECIFICALLY DISCLAIM ANY
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"
  BASIS, AND THE UNIVERSITY OF NORTH CAROLINA HAS NO OBLIGATION
  TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
  MODIFICATIONS.


   --------------------------------- 
  |Please send all BUG REPORTS to:  |
  |                                 |
  |   geom@cs.unc.edu               |
  |                                 |
   ---------------------------------
  
     
  The authors may be contacted via:

  US Mail:  A. Pattekar/J. Cohen/T. Hudson/S. Gottschalk/M. Lin/D. Manocha
            Department of Computer Science
            Sitterson Hall, CB #3175
            University of N. Carolina
            Chapel Hill, NC 27599-3175
	    
  Phone:    (919)962-1749
	    
  EMail:    geom@cs.unc.edu

\************************************************************************/

/************************************************************************\
Filename: VInternal.H
--
Description: This file declares three classes - VCReportType,
             VCObject and VCInternal.
             VCReportType is a simple class through which
             collisions are reported.
             VCObject holds all the necessary information
             about an object.
             VCInternal contains the implementation of VCollide.

\************************************************************************/


#ifndef VINTERNAL_H
#define VINTERNAL_H

#include "RAPID.H"
#include "NBody.H"

//state in which VCollide is:
const int VCstate_default   = 0; //default state
const int VCstate_newObject = 1; //a new object has been created but its
                                 //geometry is yet to be inputted.
const int VCstate_addTri    = 2; //the geometry is being inputted.


class VCReportType;
       //multiply defined in VInternal.C, VCollide.H and VCollide.h
       //this was done so that the implementation can be hidden from the
       //user.

/************************************************************************
Class: VCObject
--
Description: Each instance of this class keeps all the necessary 
             information about an object.

\************************************************************************/

class VCObject
{
  friend class VCInternal;
  
private:
  
  int         id;          //the id of the object.
  RAPID_model *b;          //RAPID box for the object. This also stores
                           //the geometry of the object.
  
  double      trans[4][4]; //the current transformation matrix for the object.
  int         activation_state; //1=>object is activated, 0=>deactivated.
};


/************************************************************************
Class: VCInternal
--
Description: Each instance of this class maintains information about a
             set of objects and activation/deactivation states between
             them. Collision detection can be performed only on
             objects that belong to the same instance of the this
             class. It uses the NBody class as its back-end.

\************************************************************************/

class VCInternal
{
  int      state;       //the state in which VCollide is.
  int      next_id;     //next free id, since ids are generated by the program.
  int      current_id;  //the id of the object being worked on by "AddTri"
                        //or "EndObject".
  NBody    nbody;       //an instance of the NBody class.
  PairData report_data; //for reporting the collisions.
  PairData disabled;    //set of disabled pairs.
  int      size;        //size of the "vcobjects" array.
  VCObject **vc_objects;//array of pointers to VCObjects.
  
public:
  VCInternal();
  ~VCInternal();

  int NewObject(int *id); //create a new object in the database.
  int AddTri(double v1[], double v2[], double v3[]); //insert the
                                                      //geometry .
  int EndObject(void);    //tell VCollide that inserting the 
                          //geometry is complete.
  int UpdateTrans(int id, double trans[][4]);
                          //update the transformation matrix of
                          //the object.
  int ActivateObject(int id);       //activate for collision detection.
  int DeactivateObject(int id);     //deactivate from collision detection.
  int ActivatePair(int id1, int id2);  //activate the pair.
  int DeactivatePair(int id1, int id2);//deactivate the pair.

  int DeleteObject(int id);  //delete the object from the database.

  int Collide(void);  //perform collision detection.

  int Report(int size, VCReportType *vcrep);
                      //report the results of collision detection.

};


#endif
