/***************************************************************************
 *   Copyright (C) 2004 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/
#include	<algebra/comebezier.h>
#include	<algebra/comepoint3d.h>
#include	<algebra/comevertex3d.h>

#include	<stdio.h>


//COME_Bezier::~COME_Bezier(){
	// Default destructor
	//setControlPoints( NULL );
//}

COME_Bezier::COME_Bezier(){
	
	COME_Vertex3D *pts = new COME_Vertex3D[4];
	pts[0].setXYZ( 0, 0, 0 );
	pts[1].setXYZ( 0, 0, 0 );
	pts[2].setXYZ( 0, 0, 0 );
	pts[3].setXYZ( 0, 0, 0 );
	setControlPoints( pts );
}

COME_Bezier::COME_Bezier( COME_Vertex3D	*pts){

	setControlPoints( pts );
}
		
COME_Vertex3D
COME_Bezier::getControlPoint( int i ){

	if( i >3 ){
		i = 3;
	}
	COME_Vertex3D *v = getControlPoints();
	return v[i];
}

void
COME_Bezier::setControlPoint( int i, COME_Vertex3D *n ){

	if( i >3 ){
		i = 3;
	}
	COME_Vertex3D *v = getControlPoints();
	v[i] = *n;
}

COME_Point3D
COME_Bezier::getPointAsPoint( float t ){

	COME_Point3D	*p = new COME_Point3D();
	COME_Vertex3D p0 = getControlPoint(0);
	COME_Vertex3D p1 = getControlPoint(1);
	COME_Vertex3D p2 = getControlPoint(2);
	COME_Vertex3D p3 = getControlPoint(3);
	
	p->setX( p0.getX()*(1-t)*(1-t)*(1-t) + p1.getX()*3*t*(1-t)*(1-t) +
						 p2.getX()*3*t*t*(1-t) + p3.getX()*t*t*t );
	p->setY( p0.getY()*(1-t)*(1-t)*(1-t) + p1.getY()*3*t*(1-t)*(1-t) +
						 p2.getY()*3*t*t*(1-t) + p3.getY()*t*t*t );
	p->setZ( p0.getZ()*(1-t)*(1-t)*(1-t) + p1.getZ()*3*t*(1-t)*(1-t) +
						 p2.getZ()*3*t*t*(1-t) + p3.getZ()*t*t*t );
	
	return *p;
}
		
COME_Vertex3D
COME_Bezier::getPointAsVertex( float t ){
	
	COME_Point3D	p = getPointAsPoint(t);
	COME_Vertex3D	*v = new COME_Vertex3D();
	v->setX( p.getX() );
	v->setY( p.getY() );
	v->setZ( p.getZ() );
	return *v;
}
