/***************************************************************************
 *   Copyright (C) 2000 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: 
//  RESPONSIBLE.: 
//
//  FILE........: vpbezier.h
//  DESCRIPTION.: Contain the VPBezier class hierarchy declarations.
//
//  AUTHOR......: Anderson Maciel
//  DATE........: 10/August/2000
//  DESCRIPTION.: Classes declaration.
//
///////////////////////////////////////////////////////////////////


#ifndef __COME_BEZIER_H
#define __COME_BEZIER_H

#include	<algebra/comecurve.h>
#include	<algebra/comevertex3d.h>


///////////////////////////////////////////////////////////////////
// Class Name: VPBezier
// Superclass: VPCurce
// Subclasses: none


class COME_Bezier : public COME_Curve{

	private:
				
	public:
		COME_Bezier();
		COME_Bezier( COME_Vertex3D	*);
		//~VPBezier();
		COME_Vertex3D	getControlPoint( int i );
		void			setControlPoint( int i, COME_Vertex3D *n );
		COME_Point3D	getPointAsPoint( float t );
		COME_Vertex3D	getPointAsVertex( float t );
};

#endif
