/***************************************************************************
 *   Copyright (C) 2000 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/
///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: 
//  RESPONSIBLE.: 
//
//  FILE........: vpcurve.h
//  DESCRIPTION.: Contain the VPCurve class hierarchy declarations.
//
//  AUTHOR......: Anderson Maciel
//  DATE........: 10/August/2000
//  DESCRIPTION.: Classes declaration.
//
///////////////////////////////////////////////////////////////////


#ifndef __COME_CURVE_H
#define __COME_CURVE_H

#include	<general/come.h>
#include	<algebra/comevertex3d.h>

///////////////////////////////////////////////////////////////////
// Class Name: VPCurve
// Superclass: VPGraphicObj
// Subclasses: VPBezier


class COME_Curve : public COME {

	private:
		COME_Vertex3D	*controlPoints;
		
	public:
		COME_Curve();
		COME_Curve( COME_Vertex3D	*);
		~COME_Curve();
		void			setControlPoints( COME_Vertex3D	* );
		COME_Vertex3D*	getControlPoints( void );
		COME_Point3D	getPointAsPoint( float t );
		COME_Vertex3D	getPointAsVertex( float t );
		void	vpRender();

};

#endif
