/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: Anderson Maciel
///
///  AUTHOR......: Fabiana Benedetti/Modified by Jean-Philippe Egger
///  DATE........: September/10/2002: Modification February/01/2004
///  DESCRIPTION.: Class and methods declaration.
///
////////////////////////////////////////////////////////////////////

#ifndef __COMEFACE_H	
#define __COMEFACE_H	

#include <general/come.h>
#include <algebra/comevector3d.h>
#include <algebra/comevertex3d.h>

#ifndef max
#define max(a,b) ((a)>(b)?(a):(b))
#define min(a,b) ((a)<(b)?(a):(b))
#endif

class COME_Mesh;
class COME_Molecule;

class COME_Face : public COME{

protected:
	vector<int>	vertices;			  /// list of indices into the Mesh's vertices array
	COME_Vector3D	normal;				  /// vector normal to this face
	COME_Vector3D	normalGlobalPosition; /// normal vector in the Global reffertial system	
	COME_Molecule	*nearestMolecule;	  /// reference to the nearest molecule to this face
	vector<int>	neighbourFaces;		  /// The neighbouring Faces
	double		color[4];
	bool		collisionDetectable;


public:
	
	bool showFace;
	COME_Vector3D referenceFace;

	
	COME_Face();
	//COME_Face( const COME_Face& pFace );
	COME_Face( vector<int> verticeN, COME_Mesh* parentN );
	COME_Face( vector<int> verticeN );
	~COME_Face();


	void			setVertex( vector<int> verticeN );
	void			setNormal( COME_Vector3D normalN );
	void			setNearestMolecule( COME_Molecule *nearest );
	void			setCollisionDetectable( bool yesno );
	
	int			getIndexVertex( int iPosN ) const;
	int			getNumberVertices() const;
	bool			getCollisionDetectable();

	COME_Vertex3D		getVertex( int iPosN ) const;
	COME_Vertex3D*		getClosestVertexPt( COME_Point3D currentPoint );
	COME_Vector3D		getNormal() const;
	vector<COME_Vertex3D>	getVertices() const;	
	COME_Molecule*		getNearestMolecule() const;
	COME_Point3D		getCenter();
	double			getArea();
	double			getStress();
	bool			containsVertexIndex( int v );
	void			replaceIndex( int v1, int v2 );
	
	double			getElasticity();
	void			updateNormal();
	double			distanceFaceFace( COME_Face face );
	bool			isInside( COME_Point3D currentPoint );
	void			update();
	
	double			geoSolidAngle( COME_Point3D point2Check );

	COME_Vector3D		vectorVertexFaceGlobalPosition( COME_Vertex3D vertex );
	
	double	distancePointPlaneGlobalPosition( COME_Point3D pPos );
	
	double	distancePointFace( COME_Point3D pPos );
	void		getClosestEdge( COME_Point3D &pA, COME_Point3D &pB, COME_Point3D p );
	bool		isInside2D( COME_Point3D pPos );
	double	distancePointFaceGlobal( COME_Point3D pPos );
	double	signedDistancePointFaceGlobal( COME_Point3D pPos );
	void		getClosestEdgeGlobal( COME_Point3D &pA, COME_Point3D &pB, COME_Point3D p );
	bool		isInside2DGlobal( COME_Point3D pPos );
	
	COME_Point3D		getClosestPointOnFaceToPoint( COME_Point3D pPos );
	COME_Vector3D	getBlendedVelocity( COME_Point3D pPos );
	bool		isInsideGlobalGOOD( COME_Point3D pPos );
	bool		intersectionRayTriangle( COME_Vector3D vRay, COME_Point3D &intersection );

	
	//*************** Added by Jean-Philippe ******************

	
	COME_Vertex3D		getVertexGlobalPosition( int iPosN ) const;
	vector<COME_Vertex3D>	getVerticesGlobalPosition() const;
	COME_Vertex3D*		getVertexGlobalPositionPt( int iPosN );
	vector<COME_Vertex3D*>	getVerticesGlobalPositionPt();

	void			updateNormalGlobalPosition();
	COME_Vector3D		getNormalGlobalPosition() const;
	COME_Vector3D*		getNormalGlobalPositionPt();

	bool			isCompletelyInside(COME_Face* face2);	
	bool			isInsideGlobalPosition( COME_Point3D currentPoint );
	
	int			getPenetratingVertex2(COME_Face* face2);
	double		penetrationDistance(COME_Point3D currentPoint);
	
	double		distanceFaceFaceGlobalPosition( COME_Face* face );
	double		distanceVertexPlaneGlobalPosition( COME_Vertex3D vertex );
		
	void			setNeighbourFaces( vector<int> faces);
	void			addNeighbour( int faceIndex);
	vector <int>	getNeighbourFaces() const;
	COME_Face *	getNeighborClosestTo( COME_Vertex3D *vPos );
	
	void			setColor(double* c);
	const double*	getColor() const;
	
	COME_Vertex3D*		getVertexPt( int iPosN );
	vector<int>		getIndexVertices();
	COME_Vertex3D		getCenterGlobalPosition();
	COME_Vertex3D*		getCenterGlobalPositionPt();

	
	static double triangleArea( COME_Point3D A, COME_Point3D B, COME_Point3D C );

};

#endif // __COMEFACE_H
