/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: 
//  RESPONSIBLE.: 
//
//  AUTHOR......: Anderson Maciel
//  DATE........: 04/November/2002
//  DESCRIPTION.: Class and new methods declaration.
//
///////////////////////////////////////////////////////////////////

#ifndef __COME_MATRIX_H
#define __COME_MATRIX_H


#include	<general/come.h>
#include	<algebra/comepoint3d.h>

#ifndef __COME_VECTOR3D_H
class COME_Vector3D;
#endif

#ifndef __COME_VERTEX3D_H
class COME_Vertex3D;
#endif

/////////////////////////////////////////////////////////////////////////
/// Class Name: COME_Matrix
/// Superclass: -
/// Subclass: -
/// Describes a 4x4 homogeneous matrix for most CG transformations
/////////////////////////////////////////////////////////////////////////

typedef double mat44 [4][4];

class COME_Matrix : public COME {


	private:
		double	data[4][4];

	protected:
		COME_Matrix	getAdjoint( void );
		double		getDet33( double, double, double, double, double, double, double, double, double );
		double		getDet22( double, double, double, double );

	public:
		COME_Matrix();
		COME_Matrix( double[] );
		COME_Matrix( double[][4] );
		~COME_Matrix();
		
		void			setValueAt( int, int, double );
		void			setMatrix( const COME_Matrix& matrixN );
		double			getValueAt( int, int ) const;
		const double** 	getMatrixD( void );
		void			getMatrixD( double ** );
		double*			getMatrixVD( void );

		COME_Matrix		getInverse( void );
		COME_Matrix		getTransposed( void );
		double			getDeterminent( void );

		COME_Matrix*	multiplyScalar( double );
		COME_Matrix*	multiply( COME_Matrix );
		COME_Matrix*	subtract( COME_Matrix );
		COME_Matrix*	add( COME_Matrix );
		COME_Point3D*		multiply ( COME_Point3D );
		void			reset();

		COME_Matrix&	operator+= ( const COME_Matrix& mO );
		COME_Matrix		operator+ ( const COME_Matrix& mO );
		COME_Matrix		operator* ( double scalar );
		COME_Matrix		operator* ( const COME_Matrix& mO );
		COME_Vector3D		operator* ( COME_Vector3D& pO );
		COME_Point3D		operator* ( const COME_Point3D& pO );
		COME_Vertex3D		operator* ( const COME_Vertex3D& vO );
};

#endif
