/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: Anderson Maciel
///
///  AUTHOR......: Fabiana Benedetti
///  DATE........: September/10/2002
///  DESCRIPTION.: Class declaration.
///
///  AUTHOR......: Anderson Maciel
///  DATE........: October/21/2002
///  DESCRIPTION.: Update method.
///
////////////////////////////////////////////////////////////////////

#ifndef __COMEMESH_H	
#define __COMEMESH_H	

#include <general/come.h>
#include <algebra/comevertex3d.h>
#include <algebra/comeface.h>

#ifndef __COME_MOLECULESTISSUE_H
class COME_MoleculesTissue;
#endif

class COME_BioStructure;

/* Image type - contains height, width, and data */
struct Image {
    unsigned long sizeX;
    unsigned long sizeY;
    char *data;
};
typedef struct Image Image;

class COME_Mesh : public COME {

protected:
	vector<COME_Vertex3D>	vertices;		//list of vertices 
	vector<COME_Vertex3D>	verticesGlobal;	//list of vertices in the global CS
	vector<COME_Face>		faces;			//list of faces (each face uses the indices of the vertices array)
	Image *texture;
	unsigned int textureID;
	static int textureCount;
	string	meshFile;

	void	edgeCollapse( int v1, int v2 );
	void	reverse(char* data,int size);

public:
	COME_Mesh();
	COME_Mesh( const vector<COME_Vertex3D> verticesN, const vector<COME_Face> facesN, COME_BioStructure* parentN );
	~COME_Mesh();
	
	int			loadImage(string filename );
	void			addFaceAsIndices( vector<int> indicesN );
	void			addVertex( COME_Vertex3D vertexN );
	void			setAVertex( COME_Vertex3D vertN, int iPosN );
	void			setCollisionDetectableFaces();

	vector<COME_Vertex3D>&	getVertices();
	vector<COME_Vertex3D>*	getVerticesPt();
	vector<COME_Vertex3D>	getVerticesGlobal();
	vector<COME_Face>	getFaces() const;
	vector<COME_Vertex3D>	getVerticesFace( int iNumberFace ) const;
	vector<COME_Vertex3D>	getVerticesFaceGlobalPosition( int iNumberFace ) const;
	COME_Vertex3D		getAVertex( int iPosN ) const;
	COME_Vertex3D		getClosestVertex( COME_Point3D givenPoint ) const;
	int			getClosestVertexIndex( COME_Point3D givenPoint ) const;
	int			getClosestFaceIndex( COME_Point3D givenPoint );
	COME_Face		getAFace( int iNumberFace ) const;
	int			getNumberFaces() const;
	Image *			getTexture();
	unsigned int		*getTextureID();
	string			getFileName();

	void			setFileName( string newName );
	void			getEnvelop( COME_Point3D& mins, COME_Point3D& maxs );
	COME_Point3D		medialPoint();
	void			updateVerticesNormals();
	bool			isInside( COME_Point3D currentPoint ); 
	void			findIntersections( COME_Point3D pi, COME_Point3D pf, vector<COME_Point3D> *allIntersections );
	bool			loadFile( string fileName, double scaleFactor, COME_Point3D originTranslation  );
	void			resetMesh();
	void			update();
	void			estabilishLinkVerticesFaces();
	int			simplify( double minDistance );
	void			scaleOnNormals( double factor );
	void			scale( double factor );
	void			scale( double factorx, double factory, double factorz );
	void			translate( double dx, double dy, double dz );
	void			rotate( double rx, double ry, double rz );
	void			transform( COME_Matrix M );
	void			anchorToMolecules( COME_MoleculesTissue* substract, int anchorNumber );
	void			resetCollisionDisps();
	int			getClosestFaceIndex( COME_Point3D givenPoint ) const;
	
	//Added by Jean
	void			changeAnchorIfNear( COME_Molecule* molecule, int anchorNumber, int vert );
	int			findDistantAnchor(int indVertex, int anchorNumber);
	void			initClosestNeighbour();
	COME_Vertex3D		calcGravityPoint(vector<COME_Vertex3D> vertices);
	double			calcVolume();
	double			calcAreaOfFace(vector<COME_Vertex3D> verticesFace);
	double			distanceVertexFace( COME_Vertex3D vertex, vector<COME_Vertex3D> verticesFace);
	COME_Vertex3D		getAVertexGlobalPosition( int iPosN );
	COME_Matrix		getGIM();
	void			updateFacesNormalsGlobalPosition();
	void			updateVerticesNormalsGlobalPosition();
	void			updateGlobalPositions();
	void			initVerticesNeighbours();
	void			initFacesNeighbours();
	COME_Face*		getAFacePt( int iNumberFace );
	vector<COME_Face*>	getPtFaces();
	vector<COME_Face>*	getFacesPt();
	vector<COME_Vertex3D>	updateMesh();
	void			updateSkin();
	vector<COME_Vertex3D>*	getVerticesGlobalPt();
	COME_Vertex3D*		getAVertexGlobalPositionPt( int iPosN );
	COME_Vertex3D*		getAVertexPt( int iPosN );

};

#endif // __COMEMESH_H

