/***************************************************************************
 *   Copyright (C) 2000 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  AUTHOR......: Anderson Maciel
///  DATE........: July/10/2000
///  DESCRIPTION.: Class declaration.
///
////////////////////////////////////////////////////////////////////


#include <algebra/comepoint2d.h>


///////////////////////////////////////////////////////////////////
// Description: Class "COME_Point2D" constructor without parameter.
// Parameters.: -
// Return.....: -

COME_Point2D::COME_Point2D () {
	point[0] = 0.0;
	point[1] = 0.0;
}


///////////////////////////////////////////////////////////////////
// Description: Class "COME_Point2D" constructor with parameter.
// Parameters.: double xi (initial x value), 
//				double yi (initial y value)
// Return.....: -

COME_Point2D::COME_Point2D (double xi, double yi) {
	point[0] = xi;
	point[1] = yi;
}


///////////////////////////////////////////////////////////////////
// Description: Method "getX" returns the value of x attribute.
// Parameters.: -
// Return.....: point[0] (value of x attribute)

double COME_Point2D::getX() {
	return point[0];
}


///////////////////////////////////////////////////////////////////
// Description: Method "getY" returns the value of y attribute.
// Parameters.: -
// Return.....: point[1] (value of y attribute)

double COME_Point2D::getY() {
	return point[1];
}


///////////////////////////////////////////////////////////////////
// Description: Method "getXY" set the value of x and y  
//				atributes to the parameters.
// Parameters.: double x (which receives the x value)
//				double y (which receives the y value)	
// Return.....: -

void COME_Point2D::getXY(double &x, double &y) {
	x = point[0];
	y = point[1];
}



///////////////////////////////////////////////////////////////////

// Description: Method "getPoint2D" get the point value.     

// Parameters.: -	

// Return.....: COME_Point2D (object)



COME_Point2D COME_Point2D::getPoint2D(void) {

	return *this;

}




///////////////////////////////////////////////////////////////////
// Description: Method "setX" sends a new value to the x attribute.
// Parameters.: double x (contains a new value for x attribute)
// Return.....: -		

void COME_Point2D::setX(double x) {
	point[0] = x;
}
	

///////////////////////////////////////////////////////////////////
// Description: Method "setY" sends a new value to the y attribute.
// Parameters.: double y (contains a new value for y attribute)
// Return.....: -		

void COME_Point2D::setY(double y) {
	point[1] = y;
}


///////////////////////////////////////////////////////////////////
// Description: Method "setXY" sends a new value to the x and y 
//				attribute.
// Parameters.: double x (contains a new value for x attribute)
//				double y (contains a new value for y attribute)
// Return.....: -		

void COME_Point2D::setXY(double x, double y) {
	point[0] = x;
	point[1] = y;
}


///////////////////////////////////////////////////////////////////
// Description: Method that implements the overload of = operator
// Parameters.: COME_Point2D p (object that has the new value for the
//					       attributes of the class)
// Return.....: COME_Point2D (current object)

COME_Point2D COME_Point2D::operator= (COME_Point2D p) {
	point[0] = p.point[0];
	point[1] = p.point[1];
	return *this;
}

COME_Point2D COME_Point2D::operator- (const COME_Point2D& p) const{
 COME_Point2D vv(point[0]-p.point[0], point[1]-p.point[1]);
 return ( vv ) ;
} 
