/***************************************************************************
 *   Copyright (C) 2000 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  AUTHOR......: Anderson Maciel
///  DATE........: August/10/2000
///  DESCRIPTION.: Class declaration.
///
////////////////////////////////////////////////////////////////////

#ifndef __COME_POINT2D_H	
#define __COME_POINT2D_H	

#include	<algebra/comepoint.h>

///////////////////////////////////////////////////////////////////
// Class Name: COME_Point2D (storage and manipulation of 2D points)
// Superclass: COME_Point
// Subclasses: -

class COME_Point2D : public COME_Point {
	private:
		double point[2];
    public:
		COME_Point2D();
		COME_Point2D(double xi, double yi);
		double getX();
		double getY();
		void getXY(double &x, double &y);

		COME_Point2D getPoint2D(void);
		void setX(double x);
		void setY(double y);
		void setXY(double x, double y);
		COME_Point2D operator= (COME_Point2D p);
		COME_Point2D operator- (const COME_Point2D&) const;
};

#endif
