/***************************************************************************
 *   Copyright (C) 2001 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  AUTHOR......: Anderson Maciel
///  DATE........: April/18/2001
///  DESCRIPTION.: Class declaration.
///
////////////////////////////////////////////////////////////////////


#include <cmath>
#include <algebra/comepoint3d.h>


///////////////////////////////////////////////////////////////////
// Description: Class "COME_Point3D" constructor without parameter.
// Parameters.: -
// Return.....: -

COME_Point3D::COME_Point3D () {
	x = 0.0;
	y = 0.0;
	z = 0.0;
}


///////////////////////////////////////////////////////////////////
// Description: Class "COME_Point3D" constructor with parameter.
// Parameters.: double xi (initial x value), 
//				double yi (initial y value),
//				double zi (initial z value)
// Return.....: -

COME_Point3D::COME_Point3D (double xi, double yi, double zi) {
	x = xi;
	y = yi;
	z = zi;
}


///////////////////////////////////////////////////////////////////
// Description: Method "getX" returns the value of x attribute.
// Parameters.: -
// Return.....: x (value of x attribute)

double COME_Point3D::getX() const {
	return x;
}


///////////////////////////////////////////////////////////////////
// Description: Method "getY" returns the value of y attribute.
// Parameters.: -
// Return.....: y (value of y attribute)

double COME_Point3D::getY() const {
	return y;
}


///////////////////////////////////////////////////////////////////
// Description: Method "getZ" returns the value of z attribute.
// Parameters.: -
// Return.....: z (value of z attribute)

double COME_Point3D::getZ() const {
	return z;
}


///////////////////////////////////////////////////////////////////
// Description: Method "getXY" set the value of x and y  
//				atributes to the parameters.
// Parameters.: double xx (which receives the x value)
//				double yy (which receives the y value)	
// Return.....: -

void COME_Point3D::getXY(double &xx, double &yy) {
	xx = x;
	yy = y;
}


///////////////////////////////////////////////////////////////////
// Description: Method "getXZ" set the value of x and z  
//				atributes to the parameters.
// Parameters.: double xx (which receives the x value)
//				double zz (which receives the z value)	
// Return.....: -

void COME_Point3D::getXZ(double &xx, double &zz) {
	xx = x;
	zz = z;
}


///////////////////////////////////////////////////////////////////
// Description: Method "getYZ" set the value of y and z  
//				atributes to the parameters.
// Parameters.: double yy (which receives the y value)
//				double zz (which receives the z value)	
// Return.....: -

void COME_Point3D::getYZ(double &yy, double &zz) {
	yy = y;
	zz = z;
}


///////////////////////////////////////////////////////////////////
// Description: Method "getXYZ" set the value of x, y and z  
//				atributes to the parameters.
// Parameters.: double xx (which receives the x value)
//				double yy (which receives the y value)
//				double zz (which receives the z value)	
// Return.....: -

void COME_Point3D::getXYZ(double &xx, double &yy, double &zz) {
	xx = x;	
	yy = y;
	zz = z;
}


///////////////////////////////////////////////////////////////////
// Description: Method "getPoint3D" get the point value.     
// Parameters.: -	
// Return.....: COME_Point3D (object)

COME_Point3D COME_Point3D::getPoint3D(void) {
	return *this;
}




///////////////////////////////////////////////////////////////////

// Description: Method "getPointAsArray" get the point value.     

// Parameters.: -	

// Return.....: double * (pointer to the array)



double* COME_Point3D::getPointAsArray( void ) const {

	double* array = new double[3]; 

	array[0] = x; 

	array[1] = y; 

	array[2] = z; 

	return array;

}





///////////////////////////////////////////////////////////////////

// Description: Method "getPoint" put the point value in an array.     

// Parameters.: double v	

// Return.....: -



void COME_Point3D::getPoint(double v[]) {

	v[0] = x;

	v[1] = y;

	v[2] = z;

}



///////////////////////////////////////////////////////////////////
// Description: Method "setX" sends a new value to the x attribute.
// Parameters.: double xx (contains a new value for x attribute)
// Return.....: -		

inline void COME_Point3D::setX(double xx) {
	x = xx;
}
	

///////////////////////////////////////////////////////////////////
// Description: Method "setY" sends a new value to the y attribute.
// Parameters.: double yy (contains a new value for y attribute)
// Return.....: -		

inline void COME_Point3D::setY(double yy) {
	y = yy;
}


///////////////////////////////////////////////////////////////////
// Description: Method "setZ" sends a new value to the z attribute.
// Parameters.: double z (contains a new value for z attribute)
// Return.....: -		

inline void COME_Point3D::setZ(double zz) {
	z = zz;
}


///////////////////////////////////////////////////////////////////
// Description: Method "setXY" sends a new value to the x and y 
//				attribute.
// Parameters.: double xx (contains a new value for x attribute)
//				double yy (contains a new value for y attribute)
// Return.....: -		

void COME_Point3D::setXY(double xx, double yy) {
	x = xx;
	y = yy;
}


///////////////////////////////////////////////////////////////////
// Description: Method "setXZ" sends a new value to the x and z 
//				attribute.
// Parameters.: double xx (contains a new value for x attribute)
//				double zz (contains a new value for z attribute)
// Return.....: -		

void COME_Point3D::setXZ(double xx, double zz) {
	x = xx;
	z = zz;
}


///////////////////////////////////////////////////////////////////
// Description: Method "setYZ" sends a new value to the y and z 
//				attribute.
// Parameters.: double yy (contains a new value for y attribute)
//				double zz (contains a new value for z attribute)
// Return.....: -		

void COME_Point3D::setYZ(double yy, double zz) {
	y = yy;
	z = zz;
}


///////////////////////////////////////////////////////////////////
// Description: Method "setXYZ" sends a new value to the x, y and  
//				z attribute.
// Parameters.: double xx (contains a new value for x attribute)
//				double yy (contains a new value for y attribute)
//				double zz (contains a new value for z attribute)
// Return.....: -		

void COME_Point3D::setXYZ(double xx, double yy, double zz) {
	x = xx;
	y = yy;
	z = zz;
}


///////////////////////////////////////////////////////////////////
// Description: Method that implements the overload of - operator
// Parameters.: COME_Point3D p (object that has the value for the
//					         operation)
// Parameters.: const COME_Point3D& p

// Return.....: COME_Point3D (result from "-" operation)

COME_Point3D COME_Point3D::operator- (const COME_Point3D& p) const{
 COME_Point3D vv(x-p.x, y-p.y, z-p.z);
 return ( vv ) ;
} 


///////////////////////////////////////////////////////////////////
// Description: Method that implements the overload of + operator
// Parameters.: COME_Point3D p (object that has the value for the
//					         operation)
// Parameters.: const COME_Point3D& p

// Return.....: COME_Point3D (result from "+" operation)

COME_Point3D COME_Point3D::operator+ (const COME_Point3D& p) {
 COME_Point3D vv(x+p.x, y+p.y, z+p.z);
 return ( vv ) ;
} 


///////////////////////////////////////////////////////////////////
// Description: Method that implements the overload of = operator
// Parameters.: COME_Point3D p (object that has the new value for the
//					       attributes of the class)
// Parameters.: const COME_Point3D& p

// Return.....: COME_Point3D (current object)

COME_Point3D COME_Point3D::operator= (COME_Point3D p) {
	x = p.x;
	y = p.y;
	z = p.z;
	return *this;
}





///////////////////////////////////////////////////////////////////

// Description: Method that implements the overload of -= operator

// Parameters.: int num (number for subtraction)

// Return.....: COME_Point3D (current object)



COME_Point3D COME_Point3D::operator-= (int num) {

 x -= num;

 y -= num;

 z -= num;

 return *this;

}



///////////////////////////////////////////////////////////////////

// Description: Method that implements the overload of -= operator

// Parameters.: int num (number for subtraction)

// Return.....: COME_Point3D (current object)



COME_Point3D COME_Point3D::operator-= (double num) {

 x -= num;

 y -= num;

 z -= num;

 return *this;

}



///////////////////////////////////////////////////////////////////

// Description: Method that implements the overload of -= operator

// Parameters.: int num (number for subtraction)

// Return.....: COME_Point3D (current object)



COME_Point3D COME_Point3D::operator+= (double num) {

 x += num;

 y += num;

 z += num;

 return *this;

}



///////////////////////////////////////////////////////////////////

// Description: Method that implements the overload of -= operator

// Parameters.: double num (number for multiplication)

// Return.....: COME_Point3D (current object)



COME_Point3D COME_Point3D::operator* (double num) {

 x *= num;

 y *= num;

 z *= num;

 return *this;

}





///////////////////////////////////////////////////////////////////

// Description: Method that implements the overload of != operator

// Parameters.: const COME_Point3D& p (object to be compared)

// Return.....: true or false



bool COME_Point3D::operator!= (const COME_Point3D& p) {

	if ( (x!=p.x) || (y!=p.y) || (z!=p.z) )

		return true;

	else

		return false;

}





///////////////////////////////////////////////////////////////////

// Description: Method that implements the overload of == operator

// Parameters.: const COME_Point3D p (object to be compared)

// Return.....: true or false



bool COME_Point3D::operator== (const COME_Point3D& p) {

	if ( (x==p.x) && (y==p.y) && (z==p.z) )

		return true;

	else

		return false;

}





///////////////////////////////////////////////////////////////////

// Description: Method that implements the overload of <= operator

// Parameters.: const COME_Point3D p (object to be compared)

// Return.....: true or false


bool COME_Point3D::operator<= (const COME_Point3D& p) {

	if ( (x<=p.x) && (y<=p.y) && (z<=p.z) )

		return true;

	else

		return false;

}





///////////////////////////////////////////////////////////////////

// Description: Method that implements the overload of < operator

// Parameters.: const COME_Point3D p (object to be compared)

// Return.....: true or false



bool COME_Point3D::operator< (const COME_Point3D& p) {

	if ( (x<p.x) && (y<p.y) && (z<p.z) )

		return true;

	else

		return false;

}





///////////////////////////////////////////////////////////////////

// Description: Method that implements the overload of >= operator

// Parameters.: const COME_Point3D p (object to be compared)

// Return.....: true or false



bool COME_Point3D::operator>= (const COME_Point3D& p) {

	if ( (x>=p.x) && (y>=p.y) && (z>=p.z) )

		return true;

	else

		return false;

}





///////////////////////////////////////////////////////////////////

// Description: Method that implements the overload of > operator

// Parameters.: const COME_Point3D p (object to be compared)

// Return.....: true or false



bool COME_Point3D::operator> (const COME_Point3D& p) {

	if ( (x>p.x) && (y>p.y) && (z>p.z) )

		return true;

	else

		return false;

}




///////////////////////////////////////////////////////////////////
// Description: Method that calculates the distance between two points
// Parameters.: COME_Point3D p 
// Return.....: double distance

double COME_Point3D::vpDistance( const COME_Point3D& p1) {
	double d;
	d = (double)sqrt((x-p1.x)*(x-p1.x) +
			 (y-p1.y)*(y-p1.y) +
			 (z-p1.z)*(z-p1.z));
	return d;
}



