/***************************************************************************
 *   Copyright (C) 2001 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  AUTHOR......: Anderson Maciel
///  DATE........: April/18/2001
///  DESCRIPTION.: Class declaration.
///
////////////////////////////////////////////////////////////////////

#ifndef __COME_POINT3D_H	
#define __COME_POINT3D_H	

#include	<algebra/comepoint.h>
#include	<algebra/comepoint2d.h>


///////////////////////////////////////////////////////////////////
// Class Name: COME_Point3D (storage and manipulation of 3D points)
// Superclass: COME_Point
// Subclasses: -

class COME_Point3D : public COME_Point {
    public:
		double x;

		double y;

		double z;

		COME_Point3D();
		COME_Point3D(double x, double y, double z);
		double getX() const;
		double getY() const;
		double getZ() const;
		void getXY(double &xx, double &yy);
		void getXZ(double &xx, double &zz);
		void getYZ(double &yy, double &zz);
		void getXYZ(double &xx, double &yy, double &zz);

		COME_Point3D getPoint3D(void);

		double* getPointAsArray(void) const;

		void getPoint(double v[]);
		void setX(double xx);
		void setY(double yy);
		void setZ(double zz);
		void setXY(double xx, double yy);
		void setXZ(double xx, double zz);
		void setYZ(double yy, double zz);
		void setXYZ(double xx, double yy, double zz);
		COME_Point3D operator= (COME_Point3D p);
		COME_Point3D operator- (const COME_Point3D&) const;
		COME_Point3D operator+ (const COME_Point3D&);
		COME_Point3D operator* (double num);

		COME_Point3D operator-= (int num);
		COME_Point3D operator-= (double num);
		COME_Point3D operator+= (double num);

		bool operator!= (const COME_Point3D&);

		bool operator== (const COME_Point3D&);

		bool operator<= (const COME_Point3D&);

		bool operator< (const COME_Point3D&);

		bool operator>= (const COME_Point3D&);

		bool operator> (const COME_Point3D&);

		double vpDistance(const COME_Point3D& p1);
};

#endif
