/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  FILE........: comesubspaceelement.cpp
///  DESCRIPTION.: 
///				   
///  AUTHOR......: Anderson Maciel
///  DATE........: July/23/2002
///  DESCRIPTION.: Class definition.
///
///////////////////////////////////////////////////////////////////

#include <algebra/comesubspaceelement.h>
#include <bio/comebiostructure.h>

//////////////////////////////////////////////////////////////////////
/// Setting
//////////////////////////////////////////////////////////////////////

void
COME_SubSpaceElement::setMass( double massN ){

	mass = massN;
}

void
COME_SubSpaceElement::setVolume( double volumeN ){

	volume = volumeN;
}

void
COME_SubSpaceElement::setPosition( COME_Point3D &positionN ){

	position_minus_one = position;
	position = COME_Point3D( positionN );
}

void
COME_SubSpaceElement::setPositionMinusOne( COME_Point3D positionN ){

	position_minus_one = positionN;
}

void
COME_SubSpaceElement::setVelocity( COME_Vector3D &velocityN ){

	velocity = COME_Vector3D( velocityN );
}

void
COME_SubSpaceElement::setAcceleration( COME_Vector3D &accelerationN ){

	acceleration = COME_Vector3D( accelerationN );
}

void
COME_SubSpaceElement::setMaterial( COME_Material *materialN ){

	material = materialN;
}

void
COME_SubSpaceElement::setIndex( int indexN ){

	index = indexN;
}

void
COME_SubSpaceElement::setStress( double stressN ){

	stress = stressN;
}

void
COME_SubSpaceElement::setStrain( double strainN ){

	strain = strainN;
}

void
COME_SubSpaceElement::setFixed( bool flag ){

	fixed = flag;
}

//////////////////////////////////////////////////////////////////////
/// Getting
//////////////////////////////////////////////////////////////////////


bool
COME_SubSpaceElement::isFixed() const{

	return fixed;
}

double
COME_SubSpaceElement::getMass() const {

	return mass;
}

double
COME_SubSpaceElement::getVolume() const {

	return volume;
}

COME_Point3D
COME_SubSpaceElement::getPosition() const {

	return position;
}

COME_Point3D
COME_SubSpaceElement::getPositionMinusOne() const {

	return position_minus_one;
}

COME_Point3D
COME_SubSpaceElement::getLastDisp() const {

	return ( position - position_minus_one );
}

COME_Point3D
COME_SubSpaceElement::getGlobalPosition() const {

	COME_Matrix localGIM = ((COME_BioStructure*)parent)->getGIM();
	if( description == "origin" )
		localGIM = COME_Matrix();
	//printf( "CHECK: Line commented because of getGIM() link error on discretizer \n" );
	if( !isFixed() )
		return position;
	return localGIM * position;
}

COME_Vector3D
COME_SubSpaceElement::getVelocity() const {

	return velocity;
}

COME_Vector3D
COME_SubSpaceElement::getAcceleration() const {

	return acceleration;
}

COME_Material*
COME_SubSpaceElement::getMaterial() const {

	return material;
}

int
COME_SubSpaceElement::getIndex() const {

	return index;
}

double
COME_SubSpaceElement::getStress() const {

	return stress;
}

double
COME_SubSpaceElement::getStrain() const {

	return strain;
}
