/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: CO-ME
//  RESPONSIBLE.: 
//
//
//  AUTHOR......: Anderson Maciel
//  DATE........: May/14/2002
//  DESCRIPTION.: Class declaration (Element).
//
//  AUTHOR......: Anderson Maciel
//  DATE........: July/23/2002
//  DESCRIPTION.: Class reformulation to SubSpaceElement.
//
///////////////////////////////////////////////////////////////////

#ifndef __COME_SUBSPACEELEMENT_H	
#define __COME_SUBSPACEELEMENT_H	


#include <general/come.h>
#include <algebra/comepoint3d.h>
#include <algebra/comevector3d.h>
#include <bio/comematerial.h>

#ifndef	__COME_BIOSTRUCTURE_H
class COME_BioStructure;
#endif

///
/// This abstract class defines a generic volumetric portion of an object.
/// It should be implemented according to any deformation method based in 
/// space subdivision, like FEM, molecular systems, mass spring systems, etc. 
///
class COME_SubSpaceElement : public COME {

protected:

	double			mass;
	double			volume;
	COME_Point3D		position;
	COME_Point3D		position_minus_one;
	COME_Vector3D	velocity;
	COME_Vector3D	acceleration;
	COME_Material		*material;
	int				index;
	double			stress;
	double			strain;
	bool				fixed;
	
public:

	void	setMass( double massN );
	void	setVolume( double volumeN );
	void	setPosition( COME_Point3D &positionN );
	void	setPositionMinusOne( COME_Point3D positionN );
	void	setVelocity( COME_Vector3D &velocityN );
	void	setAcceleration( COME_Vector3D &accelerationN );
	void	setMaterial( COME_Material *materialN );
	void	setIndex( int indexN );
	void	setStress( double stressN );
	void	setStrain( double strainN );
	void	setFixed( bool flag );

	double			getMass() const;
	double			getVolume() const;
	COME_Point3D		getPosition() const;
	COME_Point3D		getPositionMinusOne() const;
	COME_Point3D		getLastDisp() const;
	COME_Point3D		getGlobalPosition() const;
	COME_Vector3D	getVelocity() const;
	COME_Vector3D	getAcceleration() const;
	COME_Material*		getMaterial() const;	
	int				getIndex() const;
	double			getStress() const;
	double			getStrain() const;
	bool				isFixed() const;
};


#endif	// __COME_SUBSPACEELEMENT_H

