/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  AUTHOR......: Anderson Maciel
///  DATE........: November/16/2002
///  DESCRIPTION.: Class definition.
///
////////////////////////////////////////////////////////////////////

#include <algebra/cometetra.h>
#include <bio/comemolecule.h>

	
//////////////////////////////////////////////////////////////////////
/// Construction/Destruction
//////////////////////////////////////////////////////////////////////
COME_Tetra :: COME_Tetra(){

	
}

COME_Tetra :: COME_Tetra( vector<COME_Molecule*> moleculesList ){

	molecules = moleculesList;

}


COME_Tetra :: ~COME_Tetra(){

	
}

//////////////////////////////////////////////////////////////////////
/// Setting
//////////////////////////////////////////////////////////////////////
void		
COME_Tetra :: setMoleculesList( vector<COME_Molecule*> moleculesList ) {
	
	molecules = moleculesList;
}

void
COME_Tetra :: setMoleculeAt( COME_Molecule *molecule, int index ){

	molecules[index] = molecule;
}

void
COME_Tetra :: addMolecule( COME_Molecule *molecule ){

	molecules.push_back( molecule );
}
	
	
//////////////////////////////////////////////////////////////////////
/// Getting
//////////////////////////////////////////////////////////////////////
		
vector<COME_Molecule*>
COME_Tetra :: getMolecules() const{

	return molecules;

}

COME_Molecule*
COME_Tetra :: getMoleculeAt( int index ) const {

	return molecules[index];
}

double
COME_Tetra :: getVolume() const{

	double area = ( ( COME_Vector3D( ( molecules[1]->getPosition() - molecules[0]->getPosition() ) +
					( molecules[2]->getPosition() - molecules[0]->getPosition() ) ).vpModule() / 2 ) * 
					( COME_Vector3D( molecules[2]->getPosition() - molecules[1]->getPosition() ).vpModule() ) ) / 2;


	COME_Vector3D unitAB; unitAB.setVector3D( molecules[1]->getPosition() - molecules[0]->getPosition() );
	unitAB.vpNormalize();
	COME_Vector3D AP; AP.setVector3D( molecules[3]->getPosition() - molecules[0]->getPosition() );
	COME_Vector3D AB; AB.setVector3D( molecules[1]->getPosition() - molecules[0]->getPosition() );
	COME_Vector3D w1 =  unitAB * AP.vpModule() * AP.vpDotProduct( AB );	             
	COME_Vector3D unitAC; 	unitAC.setVector3D( molecules[2]->getPosition() - molecules[0]->getPosition() );
	unitAC.vpNormalize();
	COME_Vector3D AC; 	AC.setVector3D( molecules[2]->getPosition() - molecules[0]->getPosition() );
	COME_Vector3D w2 =  unitAC * AP.vpModule() * AP.vpDotProduct( AC );	
	COME_Point3D pointPlane = w1 + w2 + molecules[3]->getPosition();
	double h = molecules[3]->getPosition().vpDistance( pointPlane );

	return area * h / 3;
}

//////////////////////////////////////////////////////////////////////
/// This method calculates and returns the Young's modulus to the part
///	of material represented by this tetrahedron by averaging the modulus
/// of the four molecules that compose it.
//////////////////////////////////////////////////////////////////////
double
COME_Tetra::getElasticity() const {

	double elasticity = ( molecules[0]->getMaterial()->getYoungsModulus() +
						 molecules[1]->getMaterial()->getYoungsModulus() +
						 molecules[2]->getMaterial()->getYoungsModulus() +
						 molecules[3]->getMaterial()->getYoungsModulus() ) / 4;

	return elasticity;
}


