/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  AUTHOR......: Anderson Maciel
///  DATE........: November/16/2002
///  DESCRIPTION.: Class and methods declaration.
///
////////////////////////////////////////////////////////////////////

#ifndef __COMETETRA_H	
#define __COMETETRA_H	

#include <general/come.h>
#include <algebra/comevector3d.h>
#include <algebra/comevertex3d.h>

class COME_Molecule;

class COME_Tetra : public COME{

protected:
	vector<COME_Molecule*> molecules;	/// The four molecules connected to form this tetrahedron.

public:
	COME_Tetra();
	COME_Tetra( vector<COME_Molecule*> moleculesList );

	~COME_Tetra();

	void	setMoleculesList( vector<COME_Molecule*> moleculesList );
	void	setMoleculeAt( COME_Molecule *molecule, int index );
	void	addMolecule( COME_Molecule *molecule );
		
	vector<COME_Molecule*>	getMolecules() const;
	COME_Molecule*			getMoleculeAt( int index ) const;
	
	double	getVolume() const;
	double	getElasticity() const;
};

#endif // __COMETETRA_H
