/***************************************************************************
 *   Copyright (C) 2001 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  AUTHOR......: Anderson Maciel
///  DATE........: April/18/2001
///  DESCRIPTION.: Class declaration.
///
////////////////////////////////////////////////////////////////////

#ifndef __COME_VECTOR3D_H	
#define __COME_VECTOR3D_H	

#include	<algebra/comepoint3d.h>

#ifndef __COME_MATRIX_H	
class COME_Matrix;
#endif


///////////////////////////////////////////////////////////////////
// Class Name: COME_Vector3D (storage and manipulation of 3D vector)
// Superclass: COME_Point3D
// Subclasses: -

class COME_Vector3D:public COME_Point3D {
  public:
	  COME_Vector3D();
	  COME_Vector3D(double xi, double yi, double zi);
	  COME_Vector3D(const COME_Vector3D&);
	  COME_Vector3D(const COME_Point3D&);
 	  COME_Vector3D& operator=(const COME_Vector3D&);
	  COME_Vector3D& operator=(const COME_Point3D&);
	  //  Comparison
      int operator==(const COME_Vector3D&);
      int operator!=(const COME_Vector3D&);
	  //  Sum, Difference, Scalar Product
      COME_Point3D operator+(COME_Point3D) const;

      COME_Point3D operator-(COME_Point3D);

      COME_Vector3D operator+(const COME_Vector3D&) const;
      COME_Vector3D operator-(const COME_Vector3D&);
      COME_Vector3D operator-();
      COME_Vector3D operator*(const double&) const;
      COME_Vector3D operator/(const double&);
      COME_Vector3D operator*(const COME_Vector3D&);
	  COME_Vector3D operator*(const COME_Point3D&);
	  COME_Vector3D operator*(const COME_Matrix&);
      //  Immediate Sum, Difference, Scalar Product
      COME_Vector3D& operator+=(const COME_Vector3D&);
      COME_Vector3D& operator-=(const COME_Vector3D&);
      COME_Vector3D& operator*=(const double&);
      COME_Vector3D& operator/=(const double&);
      //  Dot Product
      double vpDotProduct(const COME_Vector3D&);
      //  Cross Product
      COME_Vector3D vpCrossProduct(const COME_Vector3D&);
	  //  Vector module
	  double vpModule() const;
      //  Vector normalization
      COME_Vector3D vpNormalize();
	  //  Set, Get
	  void setVector3D(COME_Point3D p);
	  void setVector3D(double xx,double yy,double zz);
	  void getVector3D(double &xx,double &yy,double &zz);
	  COME_Vector3D getVector3D(void);
	  COME_Point3D getVectorAsPoint3D(void);
	  double getVector3DX(void);
	  double getVector3DY(void);
	  double getVector3DZ(void);
	  double maxK(void);

	  double	getAngle( COME_Vector3D& v );
	  COME_Matrix transMult ( COME_Vector3D& v );
};



//  The global constant COME_Vector3Ds
const COME_Vector3D VZERO ( 0.0, 0.0, 0.0 );
const COME_Vector3D VX    ( 1.0, 0.0, 0.0 );
const COME_Vector3D VY    ( 0.0, 1.0, 0.0 );
const COME_Vector3D VZ    ( 0.0, 0.0, 1.0 );

#endif
