/***************************************************************************
 *   Copyright (C) 2000 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//  FILE........: vpvector3d.h
//  DESCRIPTION.: Contain the COME_Vector3D class declarations.
//
//  AUTHOR......: Anderson Maciel
//  DATE........: August/22/2000
//  DESCRIPTION.: Classe and methods declaration.
//
///////////////////////////////////////////////////////////////////

#ifndef __COME_VERTEX3D_H
#define __COME_VERTEX3D_H

#include <algebra/comepoint3d.h>
#include <algebra/comevector3d.h>

enum {CL_RED, CL_GREEN, CL_BLUE, CL_APLHA};

//#ifndef __COME_MOLECULE_H
class COME_Molecule;
class COME_Mesh;
//#endif

/////////////////////////////////////////////////////////////////////////
// Class Name: COME_Vertex3D
// Superclass: COME_Point3D
// Subclass: -

class COME_Vertex3D: public COME_Point3D {

	private:
		double			color[4]; //Use CL_RED, CL_GREEN, CL_BLUE and CL_ALPHA as indices
		COME_Point2D		texCoord;
		COME_Vector3D	normal;
		COME_Vector3D	collisionDisp;
		COME_Vector3D	velocityDisp;
		//int				collisionCount;
		//int				velocityCount;
		bool				collide;
		COME_Vector3D	normalGlobalPosition;
		int				ownerFace;
		vector<int>			neighbourFaces;
		vector<COME_Vertex3D *>	neighborVerts;
	public:
		
		COME_Vertex3D ( void );
		COME_Vertex3D( double x, double y, double z);
		COME_Vertex3D( COME_Vertex3D *v);
		COME_Vertex3D( const COME_Vertex3D &v);
		COME_Vertex3D( double x, double y, double z, short int color[4]);
		COME_Vertex3D( double x, double y, double z, COME_Vector3D n);
		COME_Vertex3D( double x, double y, double z, short int c[4], COME_Vector3D n);
		COME_Vertex3D& operator=(COME_Vertex3D&);
		COME_Vertex3D& operator=(const COME_Vector3D&);
		COME_Vertex3D& operator+=(const COME_Vector3D&);
		
		COME_Vector3D		getNormal( void );
		COME_Vector3D		getCollisionDisp( void );
		COME_Vector3D		getCollisionDispAvg( void );
		COME_Vector3D		getVelocityDisp( void );
		COME_Vector3D		getVelocityDispAvg( void );
		COME_Vector3D		getBlendedVelocity( void );
		int			getOwnerFace( void );
		COME_Point3D		getBlendedPosition( void );
		COME_Point2D		getTexCoord( void );
		vector<COME_Molecule*>&	getAnchors( void );
		vector<COME_Molecule*>*	getAnchorsPt( void );
		vector<COME_Point3D>&	getLocalPositions( void );
		double 			getStress( void );
		double 			getStrain( void );
		COME_Vector3D	getColorMaterial( void );
		COME_Point3D		getVertexAsPoint3D();

		void	setColor(double* c);
		double*	getColor();
		void 	setNormal (COME_Vector3D n);
		void 	setCollisionDisp (COME_Vector3D c);
		void 	addCollisionDisp (COME_Vector3D c);
		void 	setVelocityDisp (COME_Vector3D c);
		void 	addVelocityDisp (COME_Vector3D c);
		void 	setOwnerFace( int index );
		void 	addAnchor( COME_Molecule* newAnchor );
		void 	addLocalPosition( COME_Point3D newPosition );
		void 	setTexCoord( COME_Point2D newUV );
		bool	anchorsCollide();
		bool	hasFixedAnchor( void );
		void	setCollide( bool yesno );
		bool	getCollide();


		vector<COME_Molecule*>	anchors;
		vector<COME_Point3D>	localPositions;
		
		//Added by Jean
		void 		setNormalGlobalPosition( COME_Vector3D n );
		COME_Vector3D*	getNormalGlobalPositionPt( void );
		COME_Vector3D	getNormalGlobalPosition( void );
		
		void		addNeighbour(int faceIndex, COME_Mesh *theMesh );
		vector<int>	getNeighbourFaces();
		vector<COME_Vertex3D *>	getNeighborVerts();
		COME_Vertex3D *	getNeighborClosestTo( COME_Vertex3D *vPos );

		//test
		COME_Point3D pPlane;

};

#endif
