/***************************************************************************
 * Quaternion class written by BlackAxe / Kolor aka Laurent Schmalen in 1997
 * this class is freeware. you are fully allowed to use this class in non-
 * commercial products. Use in commercial environment is strictly prohibited
 * if you use this, i'll be happy if you greet/credit me and my group
 *
 * Official Version 0.9
 *
 * Laurent aka Blackaxe/KoLoR
 */


#ifndef BA_QUATERNION_H__
#define BA_QUATERNION_H__

//#include <iostream.h>
#include <algebra/comevector3d.h>

#ifndef PI
#define PI 3.14159264
#endif

class Quaternion
{
  private:
    double W, X, Y, Z;      // components of a quaternion

  public:
    // default constructor
    Quaternion();
    Quaternion(const double, const double = 0.0, const double = 0.0, const double = 0.0);
  
    // print a quaternion using streams
//    void PrintOn(ostream& = cout) const;

    // quaternion multiplication
    friend Quaternion operator * (const Quaternion&, const Quaternion&);
    const Quaternion& operator *= (const Quaternion&);

    // konjugiertes Quaternion
    const Quaternion& operator ~ ();

    // this function inverts the quaternion
    const Quaternion& operator - ();

    // this normalizes a quaternion 
    const Quaternion& Normalize();
    const Quaternion& FromAxis(const double, double, double, double);
    void ToMatrix(double matrix[3][3]) const;

    void Slerp(const Quaternion&, const Quaternion&, const double);

    // some additional Quaternion functions
    // getting the exponent of a quaternion
    const Quaternion& exp();
    const Quaternion& log();
	
	//Added by Jean create a quaternion from two vectors
	void Quaternion::makeFromVecs(COME_Vector3D vec1, COME_Vector3D vec2); // modified Ken Shoemake - tested ok
	void Quaternion::setAxisAngle(double axis_angle[]);
	void Quaternion::setAxisAngle(COME_Vector3D axis, double angle);  // radians


};

//inline ostream& operator << (ostream &strm, const Quaternion &q)
//{
//  q.PrintOn(strm);
//  return strm;
//}

#endif
