/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  AUTHOR......: Anderson Maciel
///  DATE........: July/31/2002
///  DESCRIPTION.: Class declaration.
///
////////////////////////////////////////////////////////////////////

#ifndef __COME_CARTILAGE_H	
#define __COME_CARTILAGE_H


#include <bio/comebiostructure.h>

///////////////////////////////////////////////////////////////////
/// An abstract class to represent one cartilage cap.
/// It must be implemented by adding specific features to provide physical
/// behavior to deform itself and calculate the new surface for a given time.
///////////////////////////////////////////////////////////////////

class COME_Cartilage : public COME_BioStructure  {

protected:
	double	surfaceFriction;

public:
	COME_Cartilage();
	virtual ~COME_Cartilage();

	virtual bool	update( double timestep, double simClock ) = 0;
	virtual void	updateSurface( bool regenerate ) = 0;
	virtual void	getEnvelop( COME_Point3D& mins, COME_Point3D& maxs ) = 0;

	virtual COME_MoleculesTissue *getTissue() = 0;

};

#endif // __COME_CARTILAGE_H
