/***************************************************************************
 *   Copyright (C) 2004 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include	<bio/comeclamp.h>
#include	<general/comescenario.h>
#include	<algebra/comemesh.h>
#include	<RAPID/RAPID.H>

//////////////////////////////////////////////////////////////////////
/// Setting
//////////////////////////////////////////////////////////////////////

COME_Clamp::COME_Clamp(){

	tissue = new COME_MoleculesTissue();
	surface = NULL;
}

COME_MoleculesTissue*
COME_Clamp::getTissue(){

	return tissue;
}


//Recalculates the Mesh based on the new positions of anchoring the molecules
void 
COME_Clamp:: updateSkin(){
	surface->updateSkin();
}

//////////////////////////////////////////////////////////////////////
/// This method re-generates the boundary mesh of the cartilage for visualization.
//////////////////////////////////////////////////////////////////////// 
void
COME_Clamp::updateSurface( bool regenerate ){

//	if( regenerate ){
//		updateSurface( 1.0, 150.0, 0.005 ); //1.0  120.0 0.005  
//		surface.estabilishLinkVerticesFaces();

		// para os pequenos 1.0, 80.0, 0.005
		// para os grandes 1.0, 160.0, 0.01
		//collision:   //2.3  (15)

//	} else {
		//generateEnvelopSurface();
//	}
  
}


//////////////////////////////////////////////////////////////////////
/// This method returns the 3D rectangular envelop of this organ.
//////////////////////////////////////////////////////////////////////// 
void
COME_Clamp::getEnvelop( COME_Point3D& mins, COME_Point3D& maxs ){

	surface->getEnvelop( mins, maxs );
}

//////////////////////////////////////////////////////////////////////
/// This method only generates the normals on the surface of the bone.
//////////////////////////////////////////////////////////////////////
void
COME_Clamp::initializeSkinning(){

	cout << "initialising Faces Neighbours...";
	this->getPointerToSurface()->initFacesNeighbours();
	cout << "done \ninitialising Vertices Neighbours...";
	this->getPointerToSurface()->initVerticesNeighbours();
	cout << "done\n";
}

//////////////////////////////////////////////////////////////////////
/// This method calculate the new torque and force on this bone center of mass.
/// Such values may be used by higher level entities to update the global position
/// of the bone.
//////////////////////////////////////////////////////////////////////// 
//////////////////////////////////////////////////////////////////////
/// This method implements the Runge-Kutta 4 method for numeric integration
/// to calculate the new positions for all molecules of this organ.
//////////////////////////////////////////////////////////////////////// 

bool
COME_Clamp::update( double timestep, double simClock ){

/*
	double xh , hh, h6;
	COME_Vector3D *dymV, *dymF, *dymT, *dymW;
	
	COME_Vector3D *dytV, *dytF, *dytT, *dytW;
	
	COME_Vector3D *ytX, *ytL, *ytP;
	COME_Matrix *ytR;

	dymV = new COME_Vector3D();
	dymF = new COME_Vector3D();
	dymT = new COME_Vector3D();
	dymW = new COME_Vector3D();
	
	dytV = new COME_Vector3D();
	dytF = new COME_Vector3D();
	dytT = new COME_Vector3D();
	dytW = new COME_Vector3D();
	
	ytX = new COME_Vector3D();
	ytL = new COME_Vector3D();
	ytP = new COME_Vector3D();
	ytR = new COME_Matrix();

	COME_Vector3D momentumTemp;
	COME_Vector3D w;

	//COME_Matrix I = COME_Matrix( rotationMatrix * inertiaTensor * rotationMatrix.getTransposed() );

	hh = timestep * 0.5;
	h6 = timestep / 6.0;
	xh = simClock + hh;
	
	// First step //////////////////////////////////////////////////////
	
	ytX->setVector3D( ( linearVelocity * hh ) + massCenter );
	ytL->setVector3D( rotationMatrix * inertiaTensor * rotationMatrix.getTransposed() * angularVelocity );
	momentumTemp.setVector3D( *ytL ); // save initial momentum
	ytP->setVector3D( linearVelocity * tissue->getMass() );
	ytR->setMatrix( rotationMatrix );
	
	// Second step //////////////////////////////////////////////////////
	derivs( xh, hh, ytX, ytL, ytP, ytR, dytV, dytF, dytT, dytW ); 

	ytX->setVector3D( ( *dytV * hh ) + massCenter );
	ytL->setVector3D( *dytW * *ytR * inertiaTensor * (*dytW * ytR->getTransposed() ) * *dytW );
	ytP->setVector3D( *dytV * tissue->getMass() );
	ytR->setMatrix( rotationMatrix );//*ytR += (*dytW); // probably non-correct

	// Third step //////////////////////////////////////////////////////
	derivs( xh, hh, ytX, ytL, ytP, ytR, dymV, dymF, dymT, dymW ); 

	ytX->setVector3D( ( *dymV * timestep ) + massCenter );
	ytL->setVector3D( *dymW * *ytR * inertiaTensor * (*dymW * ytR->getTransposed() ) * *dymW );
	ytP->setVector3D( *dymV * tissue->getMass() );
	ytR->setMatrix( rotationMatrix );//ytR->setMatrix( *( dymWR->add( *ytR ) ) );

	*dymV += *dytV;
	*dymF += *dytF;
	*dymT += *dytT;
	*dymW += *dytW;


	// Fourth step //////////////////////////////////////////////////////
	derivs( simClock + timestep, timestep, ytX, ytL, ytP, ytR, dytV, dytF, dytT, dytW ); 

	massCenter = ( ( linearVelocity + *dytV + ( *dymV * 2.0 ) ) * h6 ) + massCenter;
	COME_Vector3D rotatedVec = COME_Vector3D( angularVelocity * rotationMatrix );
	rotationMatrix = ( ( angularVelocity + (*dytW * *ytR) + ( *dymW * *ytR * 2.0 ) ) * h6 ).transMult( rotatedVec );
	angularVelocity =  rotationMatrix * inertiaTensor.getInverse() * rotationMatrix.getTransposed() * momentumTemp;
	linearVelocity = ( ( linearVelocity + *dytV + ( *dymV * 2.0 ) ) * h6 ) * tissue->getMass();
		
	delete dymV;
	delete dymF;
	delete dymT;
	delete dymW;
	
	delete dytV; 
	delete dytF;
	delete dytT;
	delete dytW;

	delete ytX;
	delete ytL;
	delete ytP;
	delete ytR;
*/
	return true;
}

void
COME_Clamp::respondCollision(){

	// do nothing, just to respond to virtual function declaration 
}