/***************************************************************************
 *   Copyright (C) 2000 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/
///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: COME_
//  RESPONSIBLE.: 
//
//  FILE........: comematerial.cpp
//  DESCRIPTION.: 
//
//  AUTHOR......: Anderson Maciel
//  DATE........: May/14/2000
//  DESCRIPTION.: Classe definition.
//
///////////////////////////////////////////////////////////////////

#include <bio/comematerial.h>

//////////////////////////////////////////////////////////////////////
/// Dafault constructor.
//////////////////////////////////////////////////////////////////////

COME_Material::COME_Material(){

	color = COME_Vector3D( 1, 1, 1 );
	anisotropyVector = COME_Vector3D( 1, 1, 1 );
	density = 1.0;
	dampingConst = 0.1;
	mediumDensity = 0.1;
	setDescription( "void" );
}

//////////////////////////////////////////////////////////////////////
/// Copy constructor.
//////////////////////////////////////////////////////////////////////
COME_Material::COME_Material( const COME_Material &materialN ){

	color = materialN.getColor();
	density = materialN.getDensity();
	dampingConst = materialN.getDamping();
	youngsModulus = materialN.getYoungsModulus();
	mediumDensity = materialN.getMediumDensity();
	description = materialN.getDescription();
	liquidFraction = materialN.getLiquidFraction();
	permeability = materialN.getPermeability();
	maxStress = materialN.getMaxStress();
	anisotropyVector = materialN.getAnisotropyVector();
}
//////////////////////////////////////////////////////////////////////
/// Complete constructor.
//////////////////////////////////////////////////////////////////////

COME_Material::COME_Material( const COME_Vector3D &colorN, double densityN, double dampingN, double youngs, double mediumDensityN, double liquidFractionN, double permeabilityN ){

	color = colorN;
	density = densityN;
	dampingConst = dampingN;
	youngsModulus = youngs;
	mediumDensity = mediumDensityN;
	liquidFraction = liquidFractionN;
	permeability = permeabilityN;
	anisotropyVector = COME_Vector3D( 1, 1, 1 );
	setDescription( "void" );
}

COME_Material::COME_Material( const COME_Vector3D &colorN, double densityN, double dampingN, double youngs, double mediumDensityN, double liquidFractionN, double permeabilityN, const COME_Vector3D &anisoN  ){

	color = colorN;
	density = densityN;
	dampingConst = dampingN;
	youngsModulus = youngs;
	mediumDensity = mediumDensityN;
	liquidFraction = liquidFractionN;
	permeability = permeabilityN;
	anisotropyVector = anisoN;
	setDescription( "void" );
}

COME_Material::~COME_Material()
{

}

//////////////////////////////////////////////////////////////////////
/// Setting
//////////////////////////////////////////////////////////////////////

void
COME_Material::setColor( const COME_Vector3D &colorN ){

	color = colorN;
}

void
COME_Material::setDensity( double densityN ){

	density = densityN;
}

void
COME_Material::setDamping( double dampingN ){

	dampingConst = dampingN;
}

void
COME_Material::setYoungsModulus( double youngsN ){

	youngsModulus = youngsN;
}

void
COME_Material::setMediumDensity( double mediumDensityN ){

	mediumDensity = mediumDensityN;
}

void
COME_Material::setLiquidFraction( double liquidN ){

	liquidFraction = liquidN;
}

void
COME_Material::setPermeability( double permeabN ){

	permeability = permeabN;
}

void
COME_Material::setMaxStress( double maxStressN ){

	maxStress = maxStressN;
}

void
COME_Material::setAnisotropyVector( const COME_Vector3D &anisoN ){

	anisotropyVector = anisoN;
}


//////////////////////////////////////////////////////////////////////
/// Getting
//////////////////////////////////////////////////////////////////////

double
COME_Material::getColorRGB() const {

	return color.vpModule();
}

COME_Vector3D
COME_Material::getColor() const {

	return color;
}

double
COME_Material::getDensity() const {

	return density;
}

double
COME_Material::getDamping() const {

	return dampingConst;
}

double
COME_Material::getYoungsModulus() const {

	return youngsModulus;
}

double
COME_Material::getMediumDensity() const {

	return mediumDensity;
}

double
COME_Material::getLiquidFraction() const{

	return liquidFraction;
}

double
COME_Material::getPermeability() const{

	return permeability;
}

double
COME_Material::getMaxStress() const{

	return maxStress;
}

COME_Vector3D
COME_Material::getAnisotropyVector() const {

	return anisotropyVector;
}
