/***************************************************************************
 *   Copyright (C) 2000 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  AUTHOR......: Anderson Maciel
///  DATE........: May/14/2000
///  DESCRIPTION.: Classe declaration.
///
///////////////////////////////////////////////////////////////////

#include <general/come.h>
#include <algebra/comevector3d.h>

#ifndef __COME_MATERIAL_H
#define __COME_MATERIAL_H

///////////////////////////////////////////////////////////////////
/// This class defines a type of material of real world.
/// The mechanical properties of the material and its consequent
/// behavior are determined by this class attributes and methods.
///////////////////////////////////////////////////////////////////

class COME_Material : public COME {

protected:
	COME_Vector3D	color;
	double		density;
	double		dampingConst;
	double		youngsModulus;
	double		mediumDensity; // This attribute will migrate to somewhere else after including multi-phasic system
	double		liquidFraction;
	double		permeability;
	double		maxStress;
	
	COME_Vector3D	anisotropyVector;

public:
	COME_Material();
	COME_Material( const COME_Material &materialN );
	COME_Material( const COME_Vector3D &colorN, double densityN, double dampingN, double youngs, double mediumDensityN, double liquidFractionN, double permeabilityN  );
	COME_Material( const COME_Vector3D &colorN, double densityN, double dampingN, double youngs, double mediumDensityN, double liquidFractionN, double permeabilityN, const COME_Vector3D &anisoN  );
	virtual ~COME_Material();

	void	setColor( const COME_Vector3D &colorN );
	void	setDensity( double densityN );
	void	setDamping( double dampingN );
	void	setYoungsModulus( double youngsN );
	void	setMediumDensity( double mediumDensityN );
	void	setLiquidFraction( double liquidN );
	void	setPermeability( double permeabN );
	void	setMaxStress( double maxStressN );
	void	setAnisotropyVector( const COME_Vector3D &anisoN );

	COME_Vector3D	getColor() const;
	double		getColorRGB() const;
	double		getDensity() const;
	double		getDamping() const;
	double		getYoungsModulus() const;
	double		getMediumDensity() const;
	double		getLiquidFraction() const;
	double		getPermeability() const;
	double		getMaxStress() const;
	COME_Vector3D	getAnisotropyVector() const;

};

#endif // COME_MATERIAL
