/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  AUTHOR......: Anderson Maciel
///  DATE........: July/31/2002
///  DESCRIPTION.: Class declaration.
///
////////////////////////////////////////////////////////////////////

#ifndef __COME_MOLECULELINK_H	
#define __COME_MOLECULELINK_H	

#include <general/come.h>
#include <algebra/cometetra.h>

//#ifndef __COME_MOLECULE_H
class COME_Molecule;
//#endif

//////////////////////////////////////////////////////////////////////
/// This class implements an atomic connection between two molecules.
//////////////////////////////////////////////////////////////////////

class COME_MoleculeLink : public COME{

protected:
	double	dampingConst;
	double	hookeConst;
	double	nominalDist;
	double	viscousFraction;
	double	frictionConst;
	COME_Molecule *element1;
	COME_Molecule *element2;
	double	flowVolume1;
	double	flowVolume2;

public:
	COME_MoleculeLink();
	COME_MoleculeLink( COME_Molecule *e1, COME_Molecule *e2 );
	~COME_MoleculeLink();

	void	setDampingConst( double dampingConstN );
	void	setHookeConst( double hookeConstN );
	void	setNominalDist( double nominalDistN );
	void	setViscousFraction( double viscousFractionN );
	void	setFrictionConst( double frictionConstN );
	void	setElement( int index, COME_Molecule* elementN );
	void	setFlowVolume( COME_Molecule* element, double volumeNew );

	double				getDampingConst() const;
	double				getHookeConst() const;
	double				getNominalDist() const;
	double				getViscousFraction() const;
	double				getFractureDist() const;
	double				getFrictionConst() const;
	double				getLength() const;
	vector<COME_Tetra>	getNeighbouringTetra() const;
	COME_Molecule*		getElement( int index );
	COME_Molecule*		getOtherElement( COME_Molecule* thisElement );
	void				recalculateSpring( int mode, double avgConnect );
	double				getFlowVolume( COME_Molecule* element ) const;

};

#endif // __COME_MOLECULELINK_H	
