/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
//
//  PROJECT.....: CO-ME
//  RESPONSIBLE.: 
//
//  AUTHOR......: Anderson Maciel
//  DATE........: October/24/2002
//  DESCRIPTION.: Class declaration.
//
////////////////////////////////////////////////////////////////////

#ifndef __COME_MOLECULESBONE_H	
#define __COME_MOLECULESBONE_H	



#include <bio/comemoleculestissue.h>
#include <bio/comebone.h>
#include <algebra/comematrix.h>


////////////////////////////////////////////////////////////////////
/// This class is an implementation of bones based on a molecular system.
/// 
////////////////////////////////////////////////////////////////////

class COME_MoleculesBone : public COME_Bone {

protected:

	COME_MoleculesTissue	*tissue;
	COME_Matrix				rotationMatrix;
	COME_Matrix				inertiaTensor;
	COME_Point3D				massCenter;
	COME_Vector3D				linearVelocity;
	COME_Vector3D				angularVelocity;

public:

	COME_MoleculesBone();
	~COME_MoleculesBone();

	void	setTissue( COME_MoleculesTissue *tissueN );
	void	setMassCenter( const COME_Point3D& massC );

	COME_MoleculesTissue	*getTissue();
	COME_Point3D				getMassCenter() const;

	void	getEnvelop( COME_Point3D& mins, COME_Point3D& maxs );

	void	updateInertiaTensor( double discretization );
	void	updateMassCenter();
	bool	update( double timestep, double simClock );
	void	updateSurface( bool regenerate );
	void	updateSurface( double skinSphere, double stiff, double resolution );
	void	updateSkin();
	
	void	generateEnvelopSurface();
	void	initializeSkinning();
	void	respondCollision();

	void	derivs( double currTime, double timestep, COME_Point3D *X, COME_Vector3D *L, COME_Vector3D *P, COME_Matrix *R, COME_Vector3D *V, COME_Vector3D *F, COME_Vector3D *T, COME_Vector3D *W );


};

#endif // __COME_MOLECULESBONE_H
