/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
//
//  PROJECT.....: CO-ME
//  RESPONSIBLE.: 
//
//  AUTHOR......: Anderson Maciel
//  DATE........: August/05/2002
//  DESCRIPTION.: Class declaration.
//
////////////////////////////////////////////////////////////////////

#ifndef __COME_MOLECULESCARTILAGE_H	
#define __COME_MOLECULESCARTILAGE_H	



#include <bio/comemoleculestissue.h>
#include <bio/comecartilage.h>
#include <libgeom/geom.h>

using namespace geom;

class COME_MoleculesCartilage : public COME_Cartilage {

protected:
	
	COME_MoleculesTissue	*tissue;
	string			deformationFile;
	ARRAY2D		*matrixJinv;
	
public:

	COME_MoleculesCartilage();
	~COME_MoleculesCartilage();

	void	setTissue( COME_MoleculesTissue *tissueN );
	void	setDeformationFile( string defFile );

	COME_MoleculesTissue	*getTissue();
	string				getDeformationFile();
	ARRAY2D				*getMatrixJinv();

	bool	update( double timestep, double simClock );
	void	updateSurface( bool regenerate );
	void	updateSurface( double skinSphere, double stiff, double resolution );
	void	updateSkin();

	void	getEnvelop( COME_Point3D& mins, COME_Point3D& maxs );
	void	respondCollision();
	
	void	initializeSkinning();
	void	discretize( int type, double dist, double radius );
	void	initializeJacobian();
};

#endif // __COME_MOLECULESCARTILAGE_H
