/***************************************************************************
 *   Copyright (C) 2003 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  AUTHOR......: Anderson Maciel
///  DATE........: January/20/2003
///  DESCRIPTION.: Class declaration.
///
////////////////////////////////////////////////////////////////////

#include <bio/comemoleculeschain.h>
#include <physics/comeforce.h>
	
	
COME_MoleculesChain::COME_MoleculesChain(){

	force = nominalLength =	lastLength = currentLength = 0.0;
}

COME_MoleculesChain::COME_MoleculesChain( vector<COME_Molecule*> moleculesN ){

	molecules = moleculesN;
	updateLengths( 0.0 );
	setNominal();
}

COME_MoleculesChain::~COME_MoleculesChain(){

}

void
COME_MoleculesChain::updateLengths( double currTime){

	lastLength = currentLength;
	currentLength =	0.0;

	for( int i = 1; i < molecules.size(); i++ ){
	
		currentLength += molecules[i]->getPosition().vpDistance( molecules[i-1]->getPosition() );
	}

	// update target based on forces applied on extremities of this chain
	COME_Force resultant_force = ( molecules[0]->externalForceTo( currTime ) ) - ( molecules[molecules.size()-1]->externalForceTo( currTime ) );
	force = resultant_force.getIntensity();

}

void
COME_MoleculesChain::setNominal(){

	nominalLength = currentLength;
}
