/***************************************************************************
 *   Copyright (C) 2003 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  AUTHOR......: Anderson Maciel
///  DATE........: January/20/2003
///  DESCRIPTION.: Class declaration.
///
////////////////////////////////////////////////////////////////////

#ifndef __COME_MoleculesChain_H	
#define __COME_MoleculesChain_H	


#include <general/come.h>
#include <bio/comemolecule.h>

////////////////////////////////////////////////////////////////////
/// Auxiliary class for implementation of a numerical method to calculate
/// k coeficients for spring connections in a molecular tissue.
/// It represents a string of molecules inside the tissue.
////////////////////////////////////////////////////////////////////

class COME_MoleculesChain: public COME {

public:

	vector<COME_Molecule*> molecules;
	double			nominalLength;
	double			lastLength;
	double			currentLength;
	double			targetLength;
	double			force;

	COME_MoleculesChain();
	~COME_MoleculesChain();
	COME_MoleculesChain( vector<COME_Molecule*> moleculesN );
	
	void updateLengths( double currTime );
	void setNominal();

};

#endif // __COME_MoleculesChain_H
