/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
//
//  PROJECT.....: CO-ME
//  RESPONSIBLE.: 
//
//  AUTHOR......: Anderson Maciel
//  DATE........: October/24/2002
//  DESCRIPTION.: Class declaration.
//
////////////////////////////////////////////////////////////////////

#ifndef __COME_MOLECULESTISSUE_H	
#define __COME_MOLECULESTISSUE_H	


#include <general/come.h>
#include <bio/comemolecule.h>
#include <bio/comemoleculeschain.h>

////////////////////////////////////////////////////////////////////
/// This class implements a bio tissue by means of a
/// molecular system.
////////////////////////////////////////////////////////////////////

class COME_MoleculesTissue : public COME {

protected:
	list<COME_Molecule*>	shape;
	double				radiusAverage;
	double				mass;
	int					averageNumConnectionsPerMolecule;
	float					accu;
	double				simTime;
	
	//void	updateSurface( double skinSphere, double stiff, double resolution );
	COME_Vector3D *dymv, *dyma, *dytv, *dyta, *ytp, *ytv, *gpuForces;


public:
	COME_MoleculesTissue();
	virtual ~COME_MoleculesTissue();

	list<COME_Molecule*>*	getShape();

	void	setRadiusAverage( double radiusN );
	void	setMass( double massN );
	void	updateAverageNumConnections();

	void	addMolecule( COME_Molecule *moleculeN );
	void	addMolecule( COME_Molecule *moleculeN, double minDdist );
	bool	updateEuler( double timestep, double simClock, string fileNameToSaveDeformation );
	bool	update( double timestep, double simClock, string fileNameToSaveDeformation );
	//void	updateSurface( bool regenerate );
	void	initForSimulation();
	void	makeAllLocalFrames();
	/* visco */ void	flow( double timestep );

	COME_Molecule*	nearestTo( COME_Point3D point );
	void		getEnvelop( COME_Point3D& mins, COME_Point3D& maxs );
	double		getMass();
	int			getAverageNumConnections();
	double		getRadiusAverage();
	COME_Point3D	getMassCenter();
	COME_Force	getGPUForce( int i );
	void		recalculateAllSpringConstants( int mode, double currTime ); 
	void		setSurfaceMolecules();
	bool		isTooClose( COME_Point3D currentPoint, double distance );

	void	setMoleculesMaterial( COME_Material* newMaterial );
	void	setMoleculesDensity( double densityN );
	void	setMoleculesElasticity( double elasticityN );
	void	setMoleculesFrictionConst( double frictionN );
	
	COME_Material* getMoleculesMaterial();

	double	getDensity();
	double	getElasticity();
	double	getFrictionConst();
	double	getTopStress();
	void	checkInitialPositions();
	void	resetInitialPositions();

	// Auxiliary to test numerical method to configure spring k's.
	COME_MoleculesChain chain;

	
	// for offline simulation
	vector<COME_Point3D*>	deformation;
	vector<double*>		deformationStresses;
	vector<double*>		deformationStrains;
	void			loadDeformationFile( string fileName );
	void			saveDeformationFile( int fileMode  );
	
	// transforms
	void	scale( double factorx, double factory, double factorz );
	void	translate( double dx, double dy, double dz );
	void	rotate( double rx, double ry, double rz );
	void	transform( COME_Matrix M );
	void	transform( COME_Matrix M, COME_Matrix MP );
	
	void	scaleNominals( double factor );
};

#endif // __COME_MOLECULESTISSUE_H
