/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: CO-ME
//  RESPONSIBLE.: 
//
//  FILE........: comepatient.CPP
//  DESCRIPTION.: 
//				   
//
//  AUTHOR......: Anderson Maciel
//  DATE........: May/27/2002
//  DESCRIPTION.: Class definition.
//
///////////////////////////////////////////////////////////////////

#include	<bio/comepatient.h>
#include	<general/comescenario.h>
#include	<bio/comebiostructure.h>
#include	<bio/comemolecule.h>
#include	<kinematics/comepolyaxialjoint.h>

//////////////////////////////////////////////////////////////////////
/// Construction/Destruction
//////////////////////////////////////////////////////////////////////

COME_Patient::COME_Patient(){

	name = "some patient";
	age = 25;
	gender = MALE;
	parent = NULL;
	rootJoint = new COME_PolyaxialJoint();
}

COME_Patient::COME_Patient( const COME_Patient &patientN ){

	name = patientN.getName();
	age = patientN.getAge();
	gender = patientN.getGender();
	weight = patientN.getWeight();
	height = patientN.getHeight();
	//rootJoint = patientN.getRootJoint();// this is not trivial DON'T USE THIS CONSTRUCTOR
	printf( "Non implemented feature in COME_Patient::COME_Patient( const COME_Patient &patientN )\n" );
	scanf("");
	////////////////////////////////////
	organList = patientN.getOrganList();
	parent = (COME_Scenario*)(patientN.getParent());
}

COME_Patient::COME_Patient( COME_Patient *patientN ){

	name = patientN->getName();
	age = patientN->getAge();
	gender = patientN->getGender();
	weight = patientN->getWeight();
	height = patientN->getHeight();
	rootJoint = patientN->getRootJoint();
	organList = patientN->getOrganList();
	parent = (COME_Scenario*)(patientN->getParent());
}

COME_Patient::COME_Patient( string nameN, short ageN, bool genderN, double weightN, double heightN, COME_Joint *root, list<COME_BioStructure*> organListN, COME *scene ){

	name = nameN;
	age = ageN;
	gender = genderN;
	weight = weightN;
	height = heightN;
	rootJoint = root;
	organList = organListN;
	parent = scene;

	list<COME_BioStructure*>::iterator iter;
	for (iter = organList.begin(); !(iter == organList.end()); iter++){
		(*iter)->setParent( this );
	}
}

COME_Patient::~COME_Patient()
{

}

//////////////////////////////////////////////////////////////////////
/// Setting
//////////////////////////////////////////////////////////////////////

void
COME_Patient::setName( string nameN ){

	name = nameN;
}

void
COME_Patient::setAge( short ageN ){

	age = ageN;
}

void
COME_Patient::setGender( bool genderN ){

	gender = genderN;
}

void
COME_Patient::setWeight( double weightN ){

	weight = weightN;
}

void
COME_Patient::setHeight( double heightN ){

	height = heightN;
}

void
COME_Patient::setOrganList( list<COME_BioStructure*> &listN ){

	organList = listN;
}

void
COME_Patient::setRootJoint( COME_Joint* rootJointN ){

	rootJoint = rootJointN;
}

//////////////////////////////////////////////////////////////////////
/// Getting
//////////////////////////////////////////////////////////////////////

string
COME_Patient::getName() const {

	return name;
}

short
COME_Patient::getAge() const {

	return age;
}

bool
COME_Patient::getGender() const {

	return gender;
}

double
COME_Patient::getWeight() const {

	return weight;
}

double
COME_Patient::getHeight() const {

	return height;
}

list<COME_BioStructure*>
COME_Patient::getOrganList() const {

	return organList;
}

const list<COME_BioStructure*>*
COME_Patient::getPtOrganList() const {

	return  &organList;
}

COME_BioStructure*
COME_Patient::getOrgan( string desc ) const {

	list<COME_BioStructure*>::const_iterator iter;
	for (iter = organList.begin(); !(iter == organList.end()); iter++){
		if( (*iter)->getDescription() == desc ){
			return (*iter);
		}
	}
	return NULL;
}

COME_BioStructure*
COME_Patient::getOrgan( int index ) const {

	list<COME_BioStructure*>::const_iterator iter;
	int i = 0;
	for (iter = organList.begin(); !(iter == organList.end()); iter++){
		if( i == index ){
			return (*iter);
		}
		i++;
	}
	return NULL;
}

COME_BioStructure*
COME_Patient::getSelected() const {

	list<COME_BioStructure*>::const_iterator iter;
	for (iter = organList.begin(); !(iter == organList.end()); iter++){
		if( (*iter)->isSelected() ){
			return (*iter);
		}
	}
	return NULL;
}

COME_Joint*
COME_Patient::getRootJoint(){

	return rootJoint;
}


COME_Joint*
COME_Patient::getJointByName( string target ){

  return searchJoint( rootJoint, target );
}

//////////////////////////////////////////////////////////////////////
/// Search the joints tree by the joint named target. Calls itself recursively to walk on the tree.
//////////////////////////////////////////////////////////////////////
COME_Joint*
COME_Patient::searchJoint( COME_Joint* currJoint, string target ){

	if( currJoint->getDescription() == target ){
		return currJoint;
	} else if( currJoint->getChildListPt()->size() > 0 ){
		return searchJoint( currJoint->getChildListPt()->front(), target );
	}
	return NULL;
}

//////////////////////////////////////////////////////////////////////
/// Add the given organ to the list of organs of this patient.
//////////////////////////////////////////////////////////////////////
void
COME_Patient::addOrgan( COME_BioStructure *organN ){

	organN->setParent( (COME_Patient*)this );
	organList.push_back( organN );
}

//////////////////////////////////////////////////////////////////////
/// Update this patient's positions accordingly to physics after timestep seconds.
//////////////////////////////////////////////////////////////////////
bool
COME_Patient::update( double timestep, double simClock ){

	list<COME_BioStructure*>::const_iterator iter;
	for (iter = organList.begin(); !(iter == organList.end()); iter++){
		//if( ((COME_Simulator*)(parent->getParent()))->getWhenRecalculate() == EVERY_ITERATION ){
		//	(*iter)->getTissue()->recalculateAllSpringConstants( ((COME_Simulator*)(parent->getParent()))->getHowRecalculate(), simClock );
		//}
		if( !(*iter)->update( timestep, simClock ) ){
			while( !(iter == organList.begin()) ){ 
				iter--;
				(*iter)->update( -timestep, simClock );
			} 
			return false;
		}
	}
	return true;
}

//////////////////////////////////////////////////////////////////////
/// This method inspects the envelops of all organs within the patient and sets the 
/// parameters mins and maxs to the minimum and maximum corners of the rectangular
/// patient envelop.
//////////////////////////////////////////////////////////////////////// 
void
COME_Patient::getEnvelop( COME_Point3D& mins, COME_Point3D& maxs ) const {

	organList.front()->getEnvelop( mins, maxs );

	list<COME_BioStructure*>::const_iterator iter;
	for (iter = organList.begin(); !(iter == organList.end()); iter++){
		
		COME_Point3D minsO , maxsO;
		(*iter)->getEnvelop( minsO, maxsO );
		
		if( minsO.getX() < mins.getX() ){
			mins.setX( minsO.getX() );
		}
		if( minsO.getY() < mins.getY() ){
			mins.setY( minsO.getY() );
		}
		if( minsO.getZ() < mins.getZ() ){
			mins.setZ( minsO.getZ() );
		}

		if( maxsO.getX() > maxs.getX() ){
			maxs.setX( maxsO.getX() );
		}
		if( maxsO.getY() > maxs.getY() ){
			maxs.setY( maxsO.getY() );
		}
		if( maxsO.getZ() > maxs.getZ() ){
			maxs.setZ( maxsO.getZ() );
		}
	}

}

void
COME_Patient::unselectAll(){

	list<COME_BioStructure*>::const_iterator iter;
	for (iter = organList.begin(); !(iter == organList.end()); iter++){
		(*iter)->select(false);
	}
}

//////////////////////////////////////////////////////////////////////
/// Update all the organs' skins
//////////////////////////////////////////////////////////////////////
void
COME_Patient::updateSkin(){

	list<COME_BioStructure*>::const_iterator iter;
	for (iter = organList.begin(); !(iter == organList.end()); iter++){
		(*iter)->updateSkin();
	}
}
