/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  AUTHOR......: Anderson Maciel
///  DATE........: May/27/2002
///  DESCRIPTION.: Class declaration.
///
///////////////////////////////////////////////////////////////////

#ifndef __COME_PATIENT_H	
#define __COME_PATIENT_H	

#include	<general/come.h>
#include	<algebra/comepoint3d.h>
#include	<kinematics/comejoint.h>



#ifndef	__COME_BIOSTRUCTURE_H
class COME_BioStructure;
#endif


///////////////////////////////////////////////////////////////////
/// This class describes a real person in the framework, particularly
/// a patient. 
///////////////////////////////////////////////////////////////////
class COME_Patient : public COME {

protected:
	string				name;
	short				age;
	bool				gender;
	double				weight;
	double				height;
	list<COME_BioStructure*>	organList;
	COME_Joint*			rootJoint;

public:
	COME_Patient();
	COME_Patient( const COME_Patient &patientN );
	COME_Patient( COME_Patient *patientN );
	COME_Patient( string nameN, short ageN, bool genderN, double weightN, double heightN, COME_Joint *root, list<COME_BioStructure*> organListN, COME *scene );
	
	virtual ~COME_Patient();

	void	setName( string nameN );
	void	setAge( short ageN );
	void	setGender( bool genderN );
	void	setWeight( double weightN );
	void	setHeight( double heightN );
	void	setOrganList( list<COME_BioStructure*> &listN );
	void	setRootJoint( COME_Joint* rootJointN );

	string				getName() const;
	short				getAge() const;
	bool				getGender() const;
	double				getWeight() const;
	double				getHeight() const;
	list<COME_BioStructure*>	getOrganList() const;
	const list<COME_BioStructure*>*	getPtOrganList() const;
	COME_BioStructure*		getOrgan( string desc ) const;
	COME_BioStructure*		getOrgan( int index ) const;
	COME_BioStructure*		getSelected() const;
	COME_Joint*			getRootJoint();
	COME_Joint*			getJointByName( string target );

	COME_Joint*	searchJoint( COME_Joint* currJoint, string target );
	void		addOrgan( COME_BioStructure *organN );
	bool		update( double timestep, double simClock );
	void		getEnvelop( COME_Point3D& mins, COME_Point3D& maxs ) const;
	void		unselectAll();
	void		updateSkin();
};

#endif // __COME_PATIENT_H
