/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  AUTHOR......: Anderson Maciel
///  DATE........: July/22/2002
///  DESCRIPTION.: Class declaration.
///
////////////////////////////////////////////////////////////////////

#ifndef __COME_H	
#define __COME_H	


#include	<stdio.h>
#include	<string.h>

#include	<list>		//STL include
#include	<string>	//STL include
#include	<vector>	//STL include
#include	<algorithm>	//STL include

#include	<iostream>

using namespace std;

//using namespace ZThread;
//namespace ZThread{
//	class Mutex;
//}
#include	<zthread/Mutex.h>

/// Compilation specials - to avoid slow code when performance is key, comment constants
/// of other applications.
 //#define	_MECHATESTER_APP
 //#define	_DISCRETIZER_APP
  #define	_MODELJOINT_APP

/// patient gender
#define		MALE		true
#define		FEMALE		false

/// simulation direction
#define		PAST		false
#define		FUTURE		true

/// iv file loading and converting to molecules
#define		MARCHING_CUBES	0
#define		VERTICES	1
#define		BEST		2


/// mesh generation deformation
#define		IMPLICIT	true
#define		DEFORM		false

/// collision detection
#define		MESH			0
#define		SPHERES			1
#define		HYBRID			2
#define		DISPLACEMENT	3
#define		NO_COLLISION		4
#define		NEIGHBORS		5
#define		SPHERICAL_SLIDING	6

/// first level of collision detection
#define		ENVELOPE	0
#define		VCOLLIDE	1

/// type of tissue
#define		CARTILAGE	0
#define		BONE		1
#define		LIGAMENT	2
#define		MUSCLE		3
#define		TENDON		4
#define		CLAMP		5
#define		CONTAINER	6

/// mode of hookes calculation
#define		NONE		0
#define		VOLUME_TETRAS	1
#define		NUM_CONNECTIONS	2
#define		ANGLES		3
#define		NUMERICALLY	4

/// frequency of hookes calculation
#define		NEVER		0
#define		ONCE		1
#define		EVERY_ITERATION	2

/// file open modes
#define		NEW	0
#define		UPDATE	1

/// simulation types
#define		OFFLINE	0
#define		ONLINE	1

/// molecules freedom
#define		FREE		0
#define		CLAMPFIX	1
#define		CLAMPMOBILE	2

/// mathematical constants
#define		M_PI		3.14159265358979323846
#define		INFINITE	1.6E+308

/// numerical integration
#define		EULER		0
#define		RUNGE_KUTTA4	1


// version control
//#define		GPU_FORCES

////////////////////////////////////////////////////////////////////
/// Highest level class for COME implementation at VRlab.
////////////////////////////////////////////////////////////////////

class COME{

protected:
	string			description;
	bool			modified;
	bool			selected;
	COME		*parent;
	ZThread::Mutex	*mutex;
	
public:

	void	setDescription( string descN );
	void	setParent( COME *parentN );

	string	getDescription() const;
	COME	*getParent() const;

	bool	isModified();
	bool	isSelected();
	void	select( bool yesno );
	
	static int instanceCount;
	static int framesOnFile;
	static int flagNumIntegration;
	static int flagCollisionTreatment;
	static bool flagCollision2ndPass;
	static bool flagExportToPrecalculatedFile;
	static bool flagSkinning;
	static double flagAnimationResolution;
	static double timestepGlobal;
	static string baseFolder;

	void	lock();
	void	unlock();

};

#endif // __COME_H
