/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: CO-ME
//  RESPONSIBLE.: 
//
//  FILE........: comescenario.h
//  DESCRIPTION.: 
//				   
//
//  AUTHOR......: Anderson Maciel
//  DATE........: June/05/2002
//  DESCRIPTION.: Class declaration.
//
///////////////////////////////////////////////////////////////////

#ifndef __COME_SCENARIO_H	
#define __COME_SCENARIO_H	

#ifndef __COMECOLLIDE_H
class COME_Collide;
#endif

#ifndef __COME_SIMULATOR_H	
class COME_Simulator;
#endif

#ifndef __COME_MOVEMENT_H	
class COME_Movement;
#endif


#include	<general/come.h>
#include	<bio/comepatient.h>
#include	<physics/comeforce.h>
#include	<bio/comematerial.h>
#include	<algebra/comevector3d.h>
//#include	<physics/comecollide.h>


class COME_Scenario : public COME {

protected:
	list<COME_Patient*>	patientList;
	COME_Collide* 		collisions;

	vector<COME_Material*>*	availableMaterials;
	COME_Vector3D		gravity;			/// m/s**2

	
	
public:

	COME_Movement*		movement;

	COME_Scenario();
	virtual ~COME_Scenario();
	
	void	setPatientList( list<COME_Patient*> &listN );
	void	setGravity( const COME_Vector3D &gravityN );

	COME_Patient	*getPatient( int index ) const;
	const COME_Vector3D	getGravity() const;
	list<COME_Patient*>*	getPatientList();
	COME_Collide*		getCollisionDetector() const;
	vector<COME_Material*>*	getAvailableMaterialsList() const;

	bool	simulate( double timestep, double simClock, bool direction );
	bool	loadFile( string file_name, COME_Simulator *simulator );
	bool	saveFile( string file_name, COME_Simulator *simulator );
	void	saveJointIntoFile( COME_Joint *jointAux, int fileMode );
	void	createPrecalculatedFiles();
	//bool	loadOrgans( vector<string> organFiles, int mode ); deprecated
	bool	loadOrganMesh( string organFile, int type, double scaleFactor = 1.0 );
	bool	addOrganFromFile( string file_name, COME_Simulator *simulator );
	bool	addMaterialsFromFile( string file_name, COME_Simulator *simulator );
	void	getEnvelop( COME_Point3D& mins, COME_Point3D& maxs ) const ;
	void	initializeAllHashs();

};

#endif // __COME_SCENARIO_H
