/***************************************************************************
 *   Copyright (C) 2003 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  AUTHOR......: Anderson Maciel
///  DATE........: October/01/2003
///  DESCRIPTION.: Classe declaration.
///
///////////////////////////////////////////////////////////////////

#include	<general/comescenario.h>
#include	<general/comesimulator.h>
#include	<general/comexml.h>
#include	<time.h>
#include	<general/cometimemanager.h>
#include	<physics/comecollide.h>
//#include	<viscoelasticity/openglview.h>
#include	<zthread/Mutex.h>



//////////////////////////////////////////////////////////////////////
/// Construction/Destruction
//////////////////////////////////////////////////////////////////////

COME_Simulator::COME_Simulator(){
/* not used constructor. verify!!
	printf("Type XML file name: ");
	char sFname[64];
	scanf("%s", sFname );

	// Set mode for recalculations of springs
	howRecalculate = 0;
	whenRecalculate = 0;

	// Create a scene from file
	scene = new COME_Scenario();
	scene->loadFile( sFname, this );
*/
	duration = 10.0;
	setFPS(400);

	//simulation dialog
	bStop = false;
	bPause = false;
	running = false;

	//howRecalculate = NUM_CONNECTIONS;
	
	mutex = new ZThread::Mutex();
	whenRecalculate = NEVER;
	howRecalculate = NONE;
}


COME_Simulator::~COME_Simulator(){

	//delete scene;
	//delete view;
}

//////////////////////////////////////////////////////////////////////
/// Setting
//////////////////////////////////////////////////////////////////////
void
COME_Simulator::setFPS( double fpsN ){

	FPS = fpsN;
	timestep = 1.0/FPS;
	COME::timestepGlobal = timestep;
}

void
COME_Simulator::setTimestep( double timestepN ){

	timestep = timestepN;
	COME::timestepGlobal = timestep;
	FPS = 1.0/timestep;
}

void
COME_Simulator::setClock( double clockN ){

	sim_clock = clockN;
}

void
COME_Simulator::setDuration( double durationN ){

	duration = durationN;
}

void
COME_Simulator::setScene( COME_Scenario *sceneN ){

	scene = sceneN;
}

void	
COME_Simulator:: setStop( bool bStopN ){

	bStop = bStopN;
}

void	
COME_Simulator:: setPause( bool bPauseN ){

	bPause = bPauseN;
}

void
COME_Simulator::setType( int ty ){

	type = ty;

}

//////////////////////////////////////////////////////////////////////
/// Getting
//////////////////////////////////////////////////////////////////////
double
COME_Simulator::getFPS() const {

	return FPS;
}

double
COME_Simulator::getTimestep() const {

	return timestep;
}

double
COME_Simulator::getClock() const {

	return sim_clock;
}

double
COME_Simulator::getDuration() const {

	return duration;
}

bool 
COME_Simulator::getPause() const{

	return bPause;
}

bool 
COME_Simulator::getStop() const{

	return bStop;
}

int
COME_Simulator::getType(){

	return type;
}

int
COME_Simulator::getHowRecalculate(){

	return howRecalculate;
}

COME_Scenario*
COME_Simulator::getScene() const{

	return scene;
}

bool
COME_Simulator::isRunning() const{

	return running;
}

void
COME_Simulator::run() {

	running = true;
	// Setup simulation parameters
	//timestep = 1.0/FPS;
	sim_clock = 0.0;
	difKinematics = 0.0;
	difDeformation = 0.0;
	difCollisions = 0.0;
	
	printf( "duration: %f\n", duration );
	printf( "TIME STEP: %f \n", timestep );
	for( sim_clock = 0-timestep; (duration < 0) || (sim_clock < duration);  ){
	
		// Go one step in the deformation/motion engine
		// If convergency is not reached, divide timestep and go again.
		if( !bPause ){
			 scene->lock();
			 scene->simulate( timestep, sim_clock += timestep, FUTURE );
			 scene->unlock();
		}
	}
	printf( "End of simulator::run thread.\n" );
	printf ("Total kinematics time was %.7f seconds. \n", difKinematics / 1000000.0 );
	printf ("Total deformation time was %.7f seconds. \n", difDeformation / 1000000.0 );
	printf ("Total collision time was %.7f seconds. \n", difCollisions / 1000000.0 );
	printf ("Signed distance called %d times. \n", scene->getCollisionDetector()->CONTADIST ); 
	running = false;
	bStop = true;
	
	// Save animation description file
	if( COME::flagExportToPrecalculatedFile ){
		COME_Xml docS;
		string strFName = "animation.xml";
		docS.saveAnimationFile( strFName, *(scene->getPatientList()), this );
	}
}
