/***************************************************************************
 *   Copyright (C) 2000 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  AUTHOR......: Anderson Maciel
///  DATE........: May/15/2000
///  DESCRIPTION.: Classe declaration.
///
///////////////////////////////////////////////////////////////////


#ifndef __COME_SIMULATOR_H
#define __COME_SIMULATOR_H

#include	<general/come.h>
#include	<gui/comeview.h>

//#include	<zthread/Thread.h>

#ifndef __COME_SCENARIO_H	
class COME_Scenario;
#endif

//class QThread{};
#include	<qthread.h>

/*
INCPATH  = -I/usr/lib/qt3/mkspecs/default -I. -I../../biomodel -I$(QTDIR)/include -I/usr/X11R6/include -I/usr/X11R6/include
LINK     = g++
LFLAGS   = 
LIBS     = $(SUBLIBS) -L$(QTDIR)/lib -L/usr/X11R6/lib -L/usr/X11R6/lib /home/amaciel/development/biomodel/general/libgeneral.a /home/amaciel/development/biomodel/physics/libphysics.a /home/amaciel/development/biomodel/VCOLLIDE/RAPID/libRapid.a /home/amaciel/development/biomodel/VCOLLIDE/libVCollide.a /home/amaciel/development/biomodel/kinematics/libkinematics.a /home/amaciel/development/biomodel/gui/libgui.a /home/amaciel/development/biomodel/bio/libbio.a /home/amaciel/development/biomodel/algebra/libalgebra.a /usr/lib/libZThread.so /usr/lib/libxerces-c.so /usr/local/lib/libQGLViewer.so /usr/X11R6/lib/libglut.so -lqt-mt -lGLU -lGL -lXmu -lXext -lX11 -lm -lpthread
*/

class COME_Simulator : public COME, public QThread { //QThread {//ZThread::Runnable {

protected:
	double	FPS;
	double	timestep;
	double	duration;
	double	sim_clock;
	int	type;		// online/offline
	bool	bStop;		//stop simulation
	bool	bPause;		//pause simulation
	bool	running;	// set when the thread is running

	int	whenRecalculate;
	int	howRecalculate;
	
	COME_Scenario	*scene; // 

public:
	COME_Simulator();
	COME_Simulator( COME_Scenario *sceneN, COME_View *viewN );
	COME_Simulator( string fileName, vector<string> organFiles );
	virtual ~COME_Simulator();

	virtual void run();

	void	setFPS( double fpsN );
	void	setTimestep( double timestepN );
	void	setClock( double clockN );
	void	setDuration( double durationN );
	void	setScene( COME_Scenario *sceneN );
	void	setStop( bool bStopN );
	void	setPause( bool bPauseN );
	void	setWhenRecalculate( int when );
	void	setHowRecalculate( int how );
	void	setType( int ty );
	

	double		getFPS() const;
	double		getTimestep() const;
	double		getClock() const;
	double		getDuration() const;
	COME_Scenario*	getScene() const;
	bool		getPause() const;
	bool		getStop() const;
	bool		isRunning() const;
	int		getWhenRecalculate();
	int		getHowRecalculate();
	int		getType();
	
	double difKinematics; /// to get time for performance test
	double difCollisions; /// to get time for performance test
	double difDeformation; /// to get time for performance test


};

#endif // __COME_SIMULATOR_H
