/***************************************************************************
 *   Copyright (C) 2003 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  AUTHOR......: Anderson Maciel
///  DATE........: Apr/24/2003
///  DESCRIPTION.: Classe implementation.
///
///////////////////////////////////////////////////////////////////

#include <general/cometimemanager.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

COME_TimeManager::COME_TimeManager(){

	addTimer( COME_Timer( 0.0, 420000, 1.0f/15.0f, 0.0 ) );

}

COME_TimeManager::~COME_TimeManager()
{

}

void
COME_TimeManager::run(){
        
	for( unsigned long int count = 0; /*forever*/ ; count++ ) { // loop up to 4 Giga times = to 119 hours of simulation.
		
		for( int i = 0; i < clocks.size(); i++ ){
			
			if( count >= ( ( clocks[i].getCurrent() + clocks[i].getStep() ) * 1000000 ) ){

				clocks[i].goStep();
			}

		}

		//qt// usleep( 100 );	// sleep 1/10'000 seconds
    }
}

void
COME_TimeManager::addTimer( COME_Timer t ){

	clocks.push_back( t );
}
